jQuery(document).ready(function ($) {
    $('.post-type-shop_order .wip-print-invoice').attr('target', '_blank');
    $('.post-type-shop_order .wip-print-packing-slip').attr('target', '_blank');
    $('.post-type-shop_order .wip-print-post-label').attr('target', '_blank');
    $('.post-type-shop_order .wip-print-sender-post-label').attr('target', '_blank');
    $('.post-type-shop_order .wip-print-recipient-post-label').attr('target', '_blank');

    $('.select-uploader').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var image = wp.media({
            title: 'انتخاب تصویر',
            multiple: false,
            button: {
                text: 'قرار دادن'
            }
        }).open().on('select', function (e) {
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $this.val(image_url);
        });
    });

    var _nonce = $('meta[name="_wip_nonce"]').attr('content');

    $('.wip-send-invoice').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var orderID = parseInt($this.data('order-id'));
        var ajaxLoader = $this.next('.wip-ajax-loader');
        ajaxLoader.show();

        $.ajax({
            url: data.ajax_url,
            type: 'post',
            dataType: 'json',
            timeout: 60000,
            data: {
                action: 'send_invoice',
                orderID: orderID,
                _wip_nonce: _nonce
            },
            success: function (response) {
                if (response._success === true) {
                    alert('فاکتور با موفقیت ارسال شد.');
                }
                ajaxLoader.hide();
            },
            error: function () {
                ajaxLoader.hide();
            }
        });
    });
});