<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Ajax {

	public function register_callback() {
		add_action( 'wp_ajax_send_invoice', array( $this, 'send_invoice' ) );
	}

	public function send_invoice() {
		check_ajax_referer( 'ajax_nonce', '_wip_nonce', true );

		$order_id = $_POST['orderID'];

		if ( ! intval( $order_id ) ) {
			wp_send_json_error();
		}

		WIP_Send_Email::manual_send( $order_id );

		$this->make_response( [
			'_success' => true,
		] );
	}

	private function make_response( $data ) {
		if ( is_array( $data ) ) {
			wp_send_json( $data );
		} else {
			die( $data );
		}
	}
}