<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Orders_Menu {

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'register_menu' ) );
	}

	/**
	 * Add a top-level menu page
	 */
	public function register_menu() {
		add_menu_page(
			'صدور سفارش‌ها',
			'صدور سفارش‌ها',
			'manage_options',
			'wip-orders',
			array( $this, 'menu_callback' ),
			'dashicons-editor-table',
			'25'
		);
	}

	/**
	 * The function to be called to output the content for this page
	 */
	public function menu_callback() {
		$file = WIP_TPL_PATH . 'tpl-orders-table.php';
		if ( is_file( $file ) && file_exists( $file ) ) {
			include( $file );
		}
	}
}