<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Print_Invoice extends WIP_Print {

	public function generate_template( $contain_barcode = true, $packing_slip = false, $is_email_tpl = false ) {

		$order = $this->get_order();
		if ( ! $order ) {
			return '';
		}
		$order_id = $order->get_id();

		$find = array(
			'##margin##',
			'##condensed##',
			'##tpl-color##',
			'##border-color##',
			'##font-face##',
			'##store-email##',
			'##store-phone##',
			'##store-logo##',
			'##store-title##',
			'##store-url##',
			'##invoice-number##',
			'##invoice-date##',
			'##barcode##',
			'##store-address##',
			'##store-postcode##',
			'##customer-address##',
			'##customer-national-id##',
			'##customer-phone##',
			'##customer-email##',
			'##order-date##',
			'##shipping-method##',
			'##transaction-id##',
			'##order-table##',
			'##total-table##',
			'##customer-note##',
			'##font-family##',
			'##font-size##',
			'##footer-desc##',
			'##total-label##',
			'##order-total##',
			'##signature##',
			'##watermark##',
			'##watermark-opacity##',
		);

		$condensed = get_option( 'wc_wip_settings_condensed' ) == 'yes' ? 'condensed' : '';

		$footer_desc = get_option( 'wc_wip_settings_footer_description' ) ? get_option( 'wc_wip_settings_footer_description' ) : '';

		$watermark = $this->get_watermark();
		$watermark = $watermark ? '<img class="watermark" src="' . $watermark . '">' : '';

		$replace = array(
			$this->get_margin(),
			$condensed,
			$this->get_color()[0],
			$this->get_color()[1],
			$this->get_font()[0],
			$this->get_store_info()['store_email'],
			$this->get_store_info()['store_phone'],
			$this->get_store_info()['store_logo'],
			$this->get_store_info()['store_title'],
			$this->get_store_info()['store_url'],
			$this->get_invoice_info( $order_id )['invoice_number'],
			$this->get_invoice_info( $order_id )['invoice_date'],
			$this->get_barcode( $contain_barcode, $this->get_invoice_info( $order_id )['invoice_number'] ),
			$this->get_store_info()['store_address'] ? '<strong>فرستنده: </strong>' . $this->get_store_info()['store_address'] : '',
			$this->get_store_info()['store_postcode'] ? '<strong>کدپستی: </strong>' . $this->get_store_info()['store_postcode'] : '',
			'<span ' . $this->show_customer_info()['show_customer_address'] . '>' . $this->get_customer_info( $order )['customer_address'] . '</span>',
			'<span ' . $this->show_customer_info()['show_customer_national_id'] . '>' . $this->get_customer_info( $order )['customer_national_id'] . '</span>',
			'<span ' . $this->show_customer_info()['show_customer_phone'] . '>' . $this->get_customer_info( $order )['customer_phone'] . '</span>',
			'<span ' . $this->show_customer_info()['show_customer_email'] . '>' . $this->get_customer_info( $order )['customer_email'] . '</span>',
			'<span ' . $this->show_customer_info()['show_order_date'] . '>' . $this->get_customer_info( $order )['order_date'] . '</span>',
			'<span ' . $this->show_customer_info()['show_shipping_method'] . '>' . $this->get_customer_info( $order )['payment_method'] . '</span>',
			'<span ' . $this->show_customer_info()['show_transaction_id'] . '>' . $this->get_customer_info( $order )['transaction_id'] . '</span>',
			'<div>' . $this->get_order_table( $order ) . '</div>',
			! $packing_slip ? '<div>' . $this->get_total_table( $order ) . '</div>' : '',
			$this->get_customer_note( $order ),
			$this->get_font()[1],
			$this->get_font_size(),
			! $packing_slip ? nl2br( $footer_desc ) : '',
			$this->get_order_total( $order )['label'],
			$this->get_order_total( $order )['value'],
			$this->get_signature(),
			$watermark,
			$this->get_watermark_opacity(),
		);

		$tpl = str_replace( $find, $replace, $this->get_template() );

		$packing_slip ? $tpl = str_replace( array(
			'invoice-title',
			'sender',
			'product-img d-none',
			'col-weight d-none',
			'col-dimensions d-none',
			'col-cabinet-code d-none',
			'total-weight d-none',
			'discount-amount',
			'footer-table'
		), array(
			'invoice-title d-none',
			'sender d-none',
			'product-img',
			'col-weight',
			'col-dimensions',
			'col-cabinet-code',
			'total-weight',
			'discount-amount d-none',
			'footer-table d-none'
		), $tpl ) : null;

		if ( empty( $this->get_store_info()['store_address'] ) ) {
			$tpl = str_replace( 'sender', 'sender d-none', $tpl );
		}

		$national_id = get_post_meta( $order->get_id(), '_billing_national_id', true );
		if ( get_option( 'wc_wip_settings_national_id' ) == 'no' || ! $national_id ) {
			$tpl = str_replace( 'national-id', 'national-id d-none', $tpl );
		}

		switch ( get_option( 'wc_wip_settings_customer_note' ) ) {
			case 'none':
				$tpl = str_replace( array( 'customer-note' ), array( 'customer-note d-none' ), $tpl );
				break;
			case 'invoice':
				if ( $packing_slip ) {
					$tpl = str_replace( array( 'customer-note' ), array( 'customer-note d-none' ), $tpl );
				}
				break;
			case 'packing_slip':
				if ( ! $packing_slip ) {
					$tpl = str_replace( array( 'customer-note' ), array( 'customer-note d-none' ), $tpl );
				}
				break;
			default:
			case 'both':
				// nothing
				break;
		}

		switch ( get_option( 'wc_wip_settings_show_product_id' ) ) {
			case 'none':
				$tpl = str_replace( array( 'product-id' ), array( 'product-id d-none' ), $tpl );
				break;
			case 'invoice':
				if ( $packing_slip ) {
					$tpl = str_replace( array( 'product-id' ), array( 'product-id d-none' ), $tpl );
				}
				break;
			case 'packing_slip':
				if ( ! $packing_slip ) {
					$tpl = str_replace( array( 'product-id' ), array( 'product-id d-none' ), $tpl );
				}
				break;
			default:
			case 'both':
				// nothing
				break;
		}

		switch ( get_option( 'wc_wip_settings_product_img' ) ) {
			default:
			case 'none':
				$tpl = str_replace( array( 'product-img' ), array( 'product-img d-none' ), $tpl );
				break;
			case 'invoice':
				if ( $packing_slip ) {
					$tpl = str_replace( array( 'product-img' ), array( 'product-img d-none' ), $tpl );
				}
				break;
			case 'packing_slip':
				if ( ! $packing_slip ) {
					$tpl = str_replace( array( 'product-img' ), array( 'product-img d-none' ), $tpl );
				}
				break;
			case 'both':
				// nothing
				break;
		}

		switch ( get_option( 'wc_wip_settings_price' ) ) {
			case 'none':
				$tpl = str_replace( array( 'price' ), array( 'price d-none' ), $tpl );
				break;
			case 'invoice':
				if ( $packing_slip ) {
					$tpl = str_replace( array( 'price' ), array( 'price d-none' ), $tpl );
				}
				break;
			case 'packing_slip':
				if ( ! $packing_slip ) {
					$tpl = str_replace( array( 'price' ), array( 'price d-none' ), $tpl );
				}
				break;
			default:
			case 'both':
				// nothing
				break;
		}

		$is_email_tpl ? $tpl = str_replace( array(
			'wip-print',
			'class="wip-invoice'
		), array(
			'wip-print d-none',
			'class="wip-invoice wip-is-email'
		), $tpl ) : null;

		get_option( 'wc_wip_settings_signature' ) == '' || $packing_slip ? $tpl = str_replace( array(
			'signature',
		), array(
			'signature d-none',
		), $tpl ) : null;

		return $tpl;
	}

	public function get_template() {
		ob_start();
		switch ( get_option( 'wc_wip_settings_template' ) ) {
			default:
			case 'template1':
				include( WIP_TPL_PATH . 'tpl-invoice1.php' );
				break;
			case 'template2':
				include( WIP_TPL_PATH . 'tpl-invoice2.php' );
				break;
			case 'template3':
				include( WIP_TPL_PATH . 'tpl-invoice3.php' );
				break;
		}
		$tpl = ob_get_clean();

		return $tpl;
	}
}