<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Print_Orders extends WIP_Print {

	public function generate_template( $contain_barcode = true, $packing_slip = false ) {
		date_default_timezone_set( 'Asia/Tehran' );

		$find = array(
			'##margin##',
			'##condensed##',
			'##font-face##',
			'##font-family##',
			'##font-size##',
		);

		$condensed = get_option( 'wc_wip_settings_condensed' ) == 'yes' ? 'condensed' : '';

		$replace = array(
			$this->get_margin(),
			$condensed,
			$this->get_font()[0],
			$this->get_font()[1],
			$this->get_font_size(),
		);

		$tpl = str_replace( $find, $replace, $this->get_template() );

		return $tpl;
	}

	public function get_template() {
		ob_start();
		$header_file = WIP_TPL_PATH . 'tpl-orders-header.php';
		if ( is_file( $header_file ) && file_exists( $header_file ) ) {
			include( $header_file );
		}

		$file = WIP_TPL_PATH . 'tpl-orders-table.php';
		if ( is_file( $file ) && file_exists( $file ) ) {
			include( $file );
		}

		?>
        <p class="wip-print">
            <button onclick="window.print()">چاپ برگه</button>
        </p></div></body></html>
		<?php
		$tpl = ob_get_clean();

		return $tpl;
	}
}