<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Print_Post_Label extends WIP_Print {

	public function generate_template( $contain_barcode = true, $packing_slip = false ) {

		$order    = $this->get_order();
		if ( ! $order ) {
			return '';
		}
		$order_id = $order->get_id();

		$find = array(
			'##margin##',
			'##font-face##',
			'##store-phone##',
			'##store-logo##',
			'##store-title##',
			'##store-url##',
			'##invoice-number##',
			'##invoice-date##',
			'##barcode##',
			'##store-address##',
			'##store-postcode##',
			'##customer-address##',
			'##customer-phone##',
			'##order-date##',
			'##shipping-method##',
			'##payment-method##',
			'##font-family##',
			'##font-size##',
		);

		$replace = array(
			$this->get_margin(),
			$this->get_font()[0],
			$this->get_store_info()['store_phone'] ? '<strong>تلفن: </strong><bdi>' . $this->get_store_info()['store_phone'] . '</bdi>' : '',
			$this->get_store_info()['store_logo'],
			$this->get_store_info()['store_title'],
			$this->get_store_info()['store_url'],
			$this->get_invoice_info( $order_id )['invoice_number'],
			$this->get_invoice_info( $order_id )['invoice_date'],
			$this->get_barcode( $contain_barcode, $this->get_invoice_info( $order_id )['invoice_number'] ),
			$this->get_store_info()['store_address'],
			$this->get_store_info()['store_postcode'] ? '- <strong>کد پستی: </strong>' . $this->get_store_info()['store_postcode'] : '',
			$this->get_customer_info( $order )['customer_address'],
			$this->get_customer_info( $order )['customer_phone'],
			$this->get_customer_info( $order )['order_date'],
			str_replace( 'به وسیله ', '', $this->get_shipping_method( $order ) ),
			$this->get_customer_info( $order )['payment_method'],
			$this->get_font()[1],
			$this->get_font_size(),
		);

		$tpl = str_replace( $find, $replace, $this->get_template() );

		return $tpl;
	}

	public function get_template() {
		ob_start();
		include( WIP_TPL_PATH . 'tpl-post-label1.php' );
		$tpl = ob_get_clean();

		return $tpl;
	}
}