<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Print_Recipient_Post_Label extends WIP_Print {

	public function generate_template( $contain_barcode = true, $packing_slip = false ) {

		$order = $this->get_order();
		if ( ! $order ) {
			return '';
		}
		$order_id = $order->get_id();

		$find = array(
			'##margin##',
			'##font-face##',
			'##customer-address##',
			'##customer-phone##',
			'##barcode##',
			'##font-family##',
			'##font-size##',
		);

		$barcode = '';
		if ( get_option( 'wc_wip_settings_barcode_recipient_post_label' ) == 'yes' ) {
			$barcode = $this->get_barcode( $contain_barcode, $this->get_invoice_info( $order_id )['invoice_number'] );
		}

		$replace = array(
			$this->get_margin(),
			$this->get_font()[0],
			$this->get_customer_info( $order )['customer_address'],
			$this->get_customer_info( $order )['customer_phone'],
			$barcode,
			$this->get_font()[1],
			$this->get_font_size(),
		);

		$tpl = str_replace( $find, $replace, $this->get_template() );

		return $tpl;
	}

	public function get_template() {
		ob_start();
		include( WIP_TPL_PATH . 'tpl-recipient-post-label.php' );
		$tpl = ob_get_clean();

		return $tpl;
	}
}