<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Print_Sender_Post_Label extends WIP_Print {

	public function generate_template( $contain_barcode = true, $packing_slip = false ) {

		$order = $this->get_order();
		if ( ! $order ) {
			return '';
		}
		$order_id = $order->get_id();

		$find = array(
			'##margin##',
			'##font-face##',
			'##store-phone##',
			'##store-title##',
			'##store-address##',
			'##store-postcode##',
			'##barcode##',
			'##font-family##',
			'##font-size##',
		);

		$barcode = '';
		if ( get_option( 'wc_wip_settings_barcode_sender_post_label' ) == 'yes' ) {
			$barcode = $this->get_barcode( $contain_barcode, $this->get_invoice_info( $order_id )['invoice_number'] );
		}

		$replace = array(
			$this->get_margin(),
			$this->get_font()[0],
			$this->get_store_info()['store_phone'] ? '- <strong>تلفن: </strong>' . '<bdi dir="ltr">' . $this->get_store_info()['store_phone'] . '</bdi>' : '',
			$this->get_store_info()['store_title'],
			$this->get_store_info()['store_address'],
			$this->get_store_info()['store_postcode'] ? '<strong>کد پستی: </strong><bdi>' . $this->get_store_info()['store_postcode'] . '</bdi>' : '',
			$barcode,
			$this->get_font()[1],
			$this->get_font_size(),
		);

		$tpl = str_replace( $find, $replace, $this->get_template() );

		return $tpl;
	}

	public function get_template() {
		ob_start();
		include( WIP_TPL_PATH . 'tpl-sender-post-label.php' );
		$tpl = ob_get_clean();

		return $tpl;
	}
}