<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

abstract class WIP_Print {

	private $order;

	public function __construct( $order_id ) {
		$order = wc_get_order( $order_id );

		$this->order = $order;
	}

	protected function get_order() {
		return $this->order;
	}

	protected abstract function generate_template( $contain_barcode = true, $packing_slip = false );

	protected abstract function get_template();

	protected function get_color() {
		$color        = get_option( 'wc_wip_settings_tpl_color' ) ? '#' . get_option( 'wc_wip_settings_tpl_color' ) : '#484848';
		$border_color = $color;

		switch ( get_option( 'wc_wip_settings_template' ) ) {
			default:
			case 'template1':
				$color = wip_convert_hex2rgba_srezasalehi( $color, 0.25 );
				break;
			case 'template2':
			case 'template3':
				// nothing
				break;
		}

		return array( $color, $border_color );
	}

	protected function get_margin() {
		$margin = get_option( 'wc_wip_settings_margin' ) ? get_option( 'wc_wip_settings_margin' ) : 0;

		return $margin;
	}

	protected function get_store_info() {
		$store_email = get_option( 'wc_wip_settings_store_email' ) ? get_option( 'wc_wip_settings_store_email' ) : '';
		$store_phone = get_option( 'wc_wip_settings_store_phone' ) ? get_option( 'wc_wip_settings_store_phone' ) : '';

		$store_logo = get_option( 'wc_wip_settings_store_logo' );
		//$logo_w     = wip_get_image_dim( $store_logo )['w'];
		//$logo_h     = wip_get_image_dim( $store_logo )['h'];
		$store_logo = '<img src="' . $store_logo . '">';

		$store_title = get_option( 'wc_wip_settings_store_title' ) ? get_option( 'wc_wip_settings_store_title' ) : '';
		$store_url   = get_option( 'wc_wip_settings_store_url' ) ? get_option( 'wc_wip_settings_store_url' ) : '';

		$store_address  = get_option( 'wc_wip_settings_store_address' ) ? get_option( 'wc_wip_settings_store_address' ) : '';
		$store_postcode = get_option( 'wc_wip_settings_store_postcode' ) ? get_option( 'wc_wip_settings_store_postcode' ) : '';

		if ( get_option( 'wc_wip_settings_vendor_addr' ) == 'yes' && isset( $_GET['is_vendor'] ) ) {
			$vendor_id = get_current_user_id();
			$profile   = get_user_meta( $vendor_id, 'dokan_profile_settings', true );
			$address   = array_key_exists( 'address', $profile ) ? $profile['address'] : array();
			$street_1  = array_key_exists( 'street_1', $address ) ? $address['street_1'] : '';
			$street_2  = array_key_exists( 'street_2', $address ) ? $address['street_2'] : '';
			$city      = array_key_exists( 'city', $address ) ? $address['city'] : '';
			$zip       = array_key_exists( 'zip', $address ) ? $address['zip'] : '';
			$state     = array_key_exists( 'state', $address ) ? $address['state'] : '';

			$city     = ( $city && ! empty( $city ) ) ? ' - ' . $city : '';
			$street_1 = ( $street_1 && ! empty( $street_1 ) ) ? ' - ' . $street_1 : '';
			$street_2 = ( $street_2 && ! empty( $street_2 ) ) ? ' - ' . $street_2 : '';

			$store_address  = $state . $city . $street_1 . $street_2;
			$store_postcode = $zip;
		}

		return array(
			'store_email'    => $store_email,
			'store_phone'    => $store_phone,
			'store_logo'     => $store_logo,
			'store_title'    => $store_title,
			'store_url'      => $store_url,
			'store_address'  => $store_address,
			'store_postcode' => $store_postcode,
		);
	}

	protected function get_invoice_info( $order_id ) {
		date_default_timezone_set( 'Asia/Tehran' );

		$invoice_prefix = get_option( 'wc_wip_settings_invoice_prefix' ) ? get_option( 'wc_wip_settings_invoice_prefix' ) . '-' : '';
		$invoice_suffix = get_option( 'wc_wip_settings_invoice_suffix' ) ? '-' . get_option( 'wc_wip_settings_invoice_suffix' ) : '';
		$invoice_start  = get_option( 'wc_wip_settings_invoice_start' ) ? get_option( 'wc_wip_settings_invoice_start' ) : 0;
		$invoice_number = $invoice_prefix . ( $invoice_start + $order_id ) . $invoice_suffix;
		$invoice_date   = date_i18n( 'Y/m/d H:i', time() );

		return array(
			'invoice_number' => $invoice_number,
			'invoice_date'   => $invoice_date,
		);
	}

	protected function get_font_size() {
		$font_size = get_option( 'wc_wip_settings_font_size' ) ? get_option( 'wc_wip_settings_font_size' ) : 13;

		return $font_size;
	}

	protected function show_customer_info() {
		$show_customer_address     = get_option( 'wc_wip_settings_customer_address' ) == 'yes' ? '' : 'class="d-none"';
		$show_customer_national_id = get_option( 'wc_wip_settings_national_id' ) == 'yes' ? '' : 'class="d-none"';
		$show_customer_phone       = get_option( 'wc_wip_settings_customer_phone' ) == 'yes' ? '' : 'class="d-none"';
		$show_customer_email       = get_option( 'wc_wip_settings_customer_email' ) == 'yes' ? '' : 'class="d-none"';
		$show_order_date           = get_option( 'wc_wip_settings_order_date' ) == 'yes' ? '' : 'class="d-none"';
		$show_shipping_method      = get_option( 'wc_wip_settings_shipping_method' ) == 'yes' ? '' : 'class="d-none"';
		$show_transaction_id       = get_option( 'wc_wip_settings_transaction_id' ) == 'yes' ? '' : 'class="d-none"';

		return array(
			'show_customer_address'     => $show_customer_address,
			'show_customer_national_id' => $show_customer_national_id,
			'show_customer_phone'       => $show_customer_phone,
			'show_customer_email'       => $show_customer_email,
			'show_order_date'           => $show_order_date,
			'show_shipping_method'      => $show_shipping_method,
			'show_transaction_id'       => $show_transaction_id,
		);
	}

	protected function get_customer_info( $order ) {
		$national_id = get_post_meta( $order->get_id(), '_billing_national_id', true );

		$customer_address     = $this->get_full_address( $order );
		$customer_national_id = '<strong>شماره ملی/کد اقتصادی: </strong>' . $national_id;
		$customer_phone       = '<strong>تلفن: </strong><bdi>' . $order->get_billing_phone() . '</bdi>';
		$customer_email       = '<strong>ایمیل: </strong>' . '<bdi>' . $order->get_billing_email() . '</bdi>';
		$order_date           = '<strong>تاریخ سفارش: </strong>' . '<bdi>' . $order->get_date_created()->date_i18n( 'Y/m/d H:i' ) . '</bdi>';
		$payment_method       = '<strong>روش پرداخت: </strong>' . $order->get_payment_method_title();

		$transaction_id = $order->get_transaction_id();
		$transaction_id = $transaction_id ? '<strong>شماره تراکنش: </strong>' . $transaction_id : null;

		return array(
			'customer_address'     => $customer_address,
			'customer_national_id' => $customer_national_id,
			'customer_phone'       => $customer_phone,
			'customer_email'       => $customer_email,
			'order_date'           => $order_date,
			'payment_method'       => $payment_method,
			'transaction_id'       => $transaction_id,
		);
	}

	protected function get_barcode( $contain_barcode, $invoice_number ) {
		$show_barcode = get_option( 'wc_wip_settings_barcode' );
		$barcode      = '';
		if ( $show_barcode == 'yes' && $contain_barcode ) {
			include( WIP_INC_PATH . 'BarcodeGenerator.php' );
			include( WIP_INC_PATH . 'BarcodeGeneratorHTML.php' );
			$generator = new Picqer\Barcode\BarcodeGeneratorHTML();
			$barcode   = $generator->getBarcode( $invoice_number, $generator::TYPE_CODE_128 );
		}

		return $barcode;
	}

	protected function get_font() {
		$font_family = get_option( 'wc_wip_settings_font_family' ) ? get_option( 'wc_wip_settings_font_family' ) : '';
		$font_face   = '';
		if ( $font_family == 'vazir' ) {
			$font_face = '@font-face {';
			$font_face .= 'font-family: vazir;';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'vazir/Vazir-FD.eot");';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'vazir/Vazir-FD.eot?#iefix") format("embedded-opentype"), ';
			$font_face .= ' url("' . WIP_FONTS_URL . 'vazir/Vazir-FD.woff2") format("woff2"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'vazir/Vazir-FD.woff") format("woff"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'vazir/Vazir-FD.ttf") format("truetype");';
			$font_face .= 'font-weight: 400;';
			$font_face .= '}';
		} else if ( $font_family == 'yekan' ) {
			$font_face = '@font-face {';
			$font_face .= 'font-family: "Yekan";';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'yekan/Yekan.eot") format("eot"), url("' . WIP_FONTS_URL . 'yekan/Yekan.woff") format("woff"), url("' . WIP_FONTS_URL . 'yekan/Yekan.ttf") format("truetype");';
			$font_face .= 'font-weight: 400;';
			$font_face .= '}';
		} else if ( $font_family == 'bnazanin' ) {
			$font_face = '@font-face {';
			$font_face .= 'font-family: "bnazanin";';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'bnazanin/BNazanin.woff2") format("woff2"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'bnazanin/BNazanin.woff") format("woff"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'bnazanin/BNazanin.ttf") format("truetype");';
			$font_face .= '}';
		} else if ( $font_family == 'bkoodak' ) {
			$font_face = '@font-face {';
			$font_face .= 'font-family: "bkoodak";';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'bkoodak/BKoodakBold.eot") format("eot"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'bkoodak/BKoodakBold.woff") format("woff"), ';
			$font_face .= 'url("' . WIP_FONTS_URL . 'bkoodak/BKoodakBold.ttf") format("truetype");';
			$font_face .= '}';
		} else if ( $font_family == 'IRANSans' ) {
			$font_face = '@font-face {';
			$font_face .= 'font-family: IRANSans;';
			$font_face .= 'font-style: normal;';
			$font_face .= 'font-weight: normal;';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'iransans/IRANSans.eot");';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'iransans/IRANSans.eot?#iefix") format("embedded-opentype");';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'iransans/IRANSans.woff2") format("woff2");';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'iransans/IRANSans.woff") format("woff");';
			$font_face .= 'src: url("' . WIP_FONTS_URL . 'iransans/IRANSans.ttf") format("truetype");';
			$font_face .= '}';
		}
		$font_family .= ', ';

		return array( $font_face, $font_family );
	}

	protected function get_full_address( $order ) {
		$address_type = get_option( 'wc_wip_settings_address_type' ) ? get_option( 'wc_wip_settings_address_type' ) : 'billing';

		if ( get_option( 'wc_wip_settings_optimize_customer_addr' ) == 'yes' ) {
			switch ( $address_type ) {
				default:
				case 'billing':
					$first_name = $order->get_billing_first_name();
					$last_name  = $order->get_billing_last_name();
					$company    = $order->get_billing_company();
					$country    = $order->get_billing_country();
					$state      = $order->get_billing_state();
					$city       = $order->get_billing_city();
					$address_1  = $order->get_billing_address_1();
					$address_2  = $order->get_billing_address_2();
					$postcode   = $order->get_billing_postcode();

					$state_name = wip_get_state_name( $country, $state );

					$first_name = $first_name ? $first_name . ' ' : '';
					$last_name  = $last_name ? $last_name . ' - ' : '';
					$company    = $company ? $company . ' - ' : '';
					$state_name = $state_name ? $state_name . ' - ' : '';
					$city       = $city ? $city . ' - ' : '';
					$address_1  = $address_1 ? $address_1 . ' - ' : '';
					$address_2  = $address_2 ? $address_2 . ' - ' : '';
					$postcode   = $postcode ? '<strong>کدپستی: </strong>' . $postcode : '';

					$full_address = $first_name . $last_name . $company . $state_name . $city . $address_1 . $address_2 . $postcode;
					break;
				case 'shipping':
					$first_name = $order->get_shipping_first_name();
					$last_name  = $order->get_shipping_last_name();
					$company    = $order->get_shipping_company();
					$country    = $order->get_shipping_country();
					$state      = $order->get_shipping_state();
					$city       = $order->get_shipping_city();
					$address_1  = $order->get_shipping_address_1();
					$address_2  = $order->get_shipping_address_2();
					$postcode   = $order->get_shipping_postcode();

					$state_name = wip_get_state_name( $country, $state );

					$first_name = $first_name ? $first_name . ' ' : '';
					$last_name  = $last_name ? $last_name . ' - ' : '';
					$company    = $company ? $company . ' - ' : '';
					$state_name = $state_name ? $state_name . ' - ' : '';
					$city       = $city ? $city . ' - ' : '';
					$address_1  = $address_1 ? $address_1 . ' - ' : '';
					$address_2  = $address_2 ? $address_2 . ' - ' : '';
					$postcode   = $postcode ? '<strong>کدپستی: </strong>' . $postcode : '';

					$full_address = $first_name . $last_name . $company . $state_name . $city . $address_1 . $address_2 . $postcode;
					break;
			}

			return $full_address;
		}

		switch ( $address_type ) {
			default:
			case 'billing':
				$full_address = $order->get_formatted_billing_address();
				break;
			case 'shipping':
				$full_address = $order->get_formatted_shipping_address() ? $order->get_formatted_shipping_address() : $order->get_formatted_billing_address();
				break;
		}

		$full_address = str_replace( array( '<br/>', '&', '"' ), ' - ', $full_address );
		$full_address = explode( '-', $full_address );
		$full_address = implode( '-', array_slice( $full_address, 0, sizeof( $full_address ) - 1 ) ) . ' - <strong>کدپستی: </strong>' . $full_address[ sizeof( $full_address ) - 1 ];

		return $full_address;
	}

	protected function get_order_table( $order ) {
		$refund_products = wip_get_refunded_products( $order->get_id() );

		$order_table = '';

		$show_weight       = get_option( 'wc_wip_settings_weight' );
		$show_dimensions   = get_option( 'wc_wip_settings_dimensions' );
		$show_cabinet_code = get_option( 'wc_wip_settings_cabinet_code' );
		$price_type        = get_option( 'wc_wip_settings_price_type' );
		$weight_unit       = get_option( 'woocommerce_weight_unit' ) ? get_option( 'woocommerce_weight_unit' ) : '';

		if ( get_option( 'wc_wip_settings_order_table' ) == 'yes' ) {
			$order_table = '<table class="order-table table-bordered">';
			$order_table .= '<thead><tr><th>#</th><th class="product-id">شناسه</th>';
			$order_table .= '<th class="product-img">تصویر محصول</th>';
			$order_table .= '<th style="max-width: 200px;">محصول</th><th class="price">قیمت واحد</th>';

			if ( $show_weight == 'yes' ) {
				$order_table .= '<th class="col-weight d-none">وزن</th>';
			}

			if ( $show_dimensions == 'yes' ) {
				$order_table .= '<th class="col-dimensions d-none">ابعاد</th>';
			}

			if ( $show_cabinet_code == 'yes' ) {
				$order_table .= '<th class="col-cabinet-code d-none">کد قفسه انبار</th>';
			}

			$order_table .= '<th>تعداد</th><th class="price">جمع</th></tr></thead>';
			$order_table .= '<tbody>';

			$discount_amount = 0;
			$total_quantity  = 0;
			$total_weight    = 0;

			$i = 0;
			foreach ( $order->get_items() as $item_id => $item_data ) {
				$product     = $item_data->get_product();
				$product_id  = $product->get_id();
				$product_sku = $product->get_sku();

				if ( $product->is_on_sale() ) {
					$discount_amount += ( ( $product->get_regular_price() - $product->get_sale_price() ) * $item_data->get_quantity() );
				}

				if ( get_option( 'wc_wip_settings_product_id' ) == 'p_sku' && $product_sku ) {
					$product_id = $product_sku;
				}

				$product_name = $product->get_name();
				if ( get_option( 'wc_wip_settings_product_name_optimize' ) == 'yes' ) {
					$product_name = wip_get_variation_name( $product );
				}

				$product_price = number_format( $item_data->get_total() / $item_data->get_quantity() ) . ' ' . get_woocommerce_currency_symbol();
				if ( $price_type == 'regular_sale' ) {
					$product_price = $product->get_price_html();
				}

				$item_quantity = $item_data->get_quantity();
				if ( $refund_products && get_option( 'wc_wip_settings_refunded_items' ) == 'yes' ) {
					foreach ( $refund_products as $item ) {
						if ( $item['id'] == $product_id ) {
							$item_quantity .= '<br><bdi dir="ltr">' . $item['quantity'] . '</bdi>';
						}
					}
				}
				$total_quantity += $item_quantity;

				if ( $show_weight == 'yes' ) {
					$product_weight = $product->get_weight();

					if ( $product_weight && is_numeric( $product_weight ) ) {
						$weight = '<bdi dir="ltr">' . $product_weight . ' x ' . $item_quantity . ' = ' . ( $product_weight * $item_quantity ) . ' ' . $weight_unit . '</bdi>';
					}
					if ( ! $product_weight ) {
						$weight = '__';
					} else {
						$total_weight += ( $product_weight * $item_quantity );
					}
				}

				if ( $show_dimensions == 'yes' ) {
					$product_dimensions = wc_format_dimensions( $product->get_dimensions( false ) );
					$dimensions         = '<bdi dir="ltr">' . $product_dimensions . '</bdi>';
					if ( ! $product->has_dimensions() ) {
						$dimensions = '__';
					}
				}

				if ( $show_cabinet_code == 'yes' ) {
					if ( $product->get_type() == 'simple' ) {
						$cabinet_code = get_post_meta( $product_id, '_wip_cabinet_code', true );
					} elseif ( $product->get_type() == 'variation' ) {
						$cabinet_code = get_post_meta( wp_get_post_parent_id( $product_id ), '_wip_cabinet_code', true );
					}
				}

				$item_total = number_format( $item_data->get_total() ) . ' ' . get_woocommerce_currency_symbol();
				if ( $refund_products && get_option( 'wc_wip_settings_refunded_items' ) == 'yes' ) {
					foreach ( $refund_products as $item ) {
						if ( $item['id'] == $product_id ) {
							$item_total .= '<br><bdi dir="ltr">' . number_format( $item['subtotal'] ) . '</bdi> ' . get_woocommerce_currency_symbol();
						}
					}
				}

				$order_table .= '<tr>';
				$order_table .= '<td>' . ( $i + 1 ) . '</td>';
				$order_table .= '<td class="product-id"><bdi>' . $product_id . '</bdi></td>';

				$order_table .= '<td class="product-img">' . wip_get_product_image( $product ) . '</td>';

				$order_table .= '<td style="max-width: 200px;">' . $product_name . '</td>';

				$order_table .= '<td class="price">' . $product_price . '</td>';

				if ( $show_weight == 'yes' ) {
					$order_table .= '<td class="col-weight d-none">' . $weight . '</td>';
				}

				if ( $show_dimensions == 'yes' ) {
					$order_table .= '<td class="col-dimensions d-none">' . $dimensions . '</td>';
				}

				if ( $show_cabinet_code == 'yes' ) {
					$order_table .= '<td class="col-cabinet-code d-none">' . $cabinet_code . '</td>';
				}

				$order_table .= '<td>' . $item_quantity . '</td>';
				$order_table .= '<td class="price">' . $item_total . '</td>';
				$order_table .= '</tr>';

				$i ++;
			}
			$order_table .= '</tbody>';
			$order_table .= '</table>';

			$order_table .= '<div style="text-align: left;">';
			if ( $show_weight == 'yes' ) {
				$order_table .= '<span class="total-weight d-none"><strong>وزن کل:</strong> <bdi dir="ltr">' . $total_weight . ' ' . $weight_unit . '</bdi>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;</span>';
			}
			if ( get_option( 'wc_wip_settings_total_quantity' ) == 'yes' ) {
				$order_table .= '<span class="total-quantity"><strong>تعداد کل اقلام:</strong> ' . $total_quantity . '</span>';
			}
			if ( get_option( 'wc_wip_settings_discount_amount' ) == 'yes' && $discount_amount > 0 ) {
				$discount_amount = number_format( $discount_amount ) . ' ' . get_woocommerce_currency_symbol();
				$order_table     .= '<span class="discount-amount">&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<strong>سود شما از این خرید:</strong> ' . $discount_amount . '</span>';
			}
			$order_table .= '</div>';
		}

		return $order_table;
	}

	protected function get_total_table( $order ) {
		$total_table = '';

		if ( get_option( 'wc_wip_settings_total_table' ) == 'yes' ) {
			$total = $order->get_order_item_totals();


			$total_table = '<table class="total-table table-bordered">';
			$total_table .= '<tbody>';
			$total_table .= '<tr><td>' . $total['cart_subtotal']['label'] . '</td><td>' . $total['cart_subtotal']['value'] . '</td></tr>';
			if ( array_key_exists( 'discount', $total ) && $total['discount'] ) {
				$total_table .= '<tr><td>' . $total['discount']['label'] . '</td><td>' . $total['discount']['value'] . '</td></tr>';
			}
			if ( array_key_exists( 'shipping', $total ) && $total['shipping']['label'] ) {
				$total_table .= '<tr><td>' . $total['shipping']['label'] . '</td><td>' . $total['shipping']['value'] . '</td></tr>';
			}

			if ( get_option( 'wc_wip_settings_tax' ) == 'yes' && $order->get_tax_totals() && is_array( $order->get_tax_totals() ) ) {
				$amount = 0;
				foreach ( $order->get_tax_totals() as $tax_key => $tax_value ) {
					if ( isset( $tax_value->formatted_amount ) ) {
						$total_table .= '<tr><td>' . $tax_key . '</td><td>' . $tax_value->formatted_amount . '</td></tr>';
					}
					if ( isset( $tax_value->amount ) ) {
						$amount += $tax_value->amount;
					}
				}
				if ( sizeof( $order->get_tax_totals() ) > 1 ) {
					$total_table .= '<tr><td>مالیات کل</td><td>' . number_format( $amount ) . ' ' . get_woocommerce_currency_symbol() . '</td></tr>';
				}
			}

			$total_table .= '<tr><td>' . $total['order_total']['label'] . '</td><td>' . $total['order_total']['value'] . '</td></tr>';
			$total_table .= '</tbody>';
			$total_table .= '</table>';
		}

		return $total_table;
	}

	protected function get_order_total( $order ) {
		$total = $order->get_order_item_totals();

		return array(
			'label' => $total['order_total']['label'],
			'value' => $total['order_total']['value'],
		);
	}

	protected function get_customer_note( $order ) {
		$customer_note = $order->get_customer_note();

		if ( $customer_note && ! empty( $customer_note ) ) {
			return '<p class="customer-note"><strong>یادداشت مشتری: </strong>' . $customer_note . '</p>';
		}

		return '';
	}

	protected function get_shipping_method( $order ) {
		$total = $order->get_order_item_totals();

		return '<strong>' . $total['shipping']['label'] . '</strong>' . ' ' . $total['shipping']['value'];
	}

	protected function get_signature() {
		$signature = get_option( 'wc_wip_settings_signature' );

		if ( ! $signature ) {
			return '';
		}

		/*$signature_w = wip_get_image_dim( $signature )['w'];
		$signature_h = wip_get_image_dim( $signature )['h'];*/
		$signature = '<img src="' . $signature . '">';

		return $signature;
	}

	protected function get_watermark() {
		$watermark = get_option( 'wc_wip_settings_watermark' );

		return $watermark;
	}

	protected function get_watermark_opacity() {
		$watermark_opacity = get_option( 'wc_wip_settings_watermark_opacity' );

		if ( ! $watermark_opacity ) {
			return 0.5;
		}

		return $watermark_opacity;
	}
}