<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'Access denied!' );

class WIP_Product_Field {

	/**
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Single instance of class
	 *
	 * @return null|WSM_Product_Field
	 */
	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * WSM_Product_Field constructor.
	 */
	public function __construct() {
		add_action( 'woocommerce_product_options_inventory_product_data', array( $this, 'custom_field' ) );
		add_action( 'woocommerce_process_product_meta', array( $this, 'save_custom_field' ) );
		add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'variation_custom_field' ), 10, 3 );
		add_action( 'woocommerce_save_product_variation', array( $this, 'save_variation_custom_field' ), 10, 2 );
	}

	/**
	 * Create new fields for variation
	 */
	public function custom_field() {
		global $post;

		echo '<div class="options_group">';
		woocommerce_wp_text_input(
			array(
				'id'          => '_wsm_provider_price',
				'label'       => 'قیمت تامین کننده',
				'placeholder' => '',
				'desc_tip'    => 'true',
				'description' => 'قیمت تامین کننده محصول را جهت نمایش در لیست مدیریت انبار وارد نمایید.',
				'value'       => get_post_meta( $post->ID, '_wsm_provider_price', true )
			)
		);
		echo '</div>';
	}

	/**
	 * Save new fields for variations
	 *
	 * @param $post_id
	 */
	function save_custom_field( $post_id ) {
		$provider_price = sanitize_text_field( $_POST['_wsm_provider_price'] );

		if ( $provider_price && ! empty( $provider_price ) ) {
			update_post_meta( $post_id, '_wsm_provider_price', $provider_price );
		} else {
			delete_post_meta( $post_id, '_wsm_provider_price' );
		}
	}

	/**
	 * Create new fields for variations
	 *
	 * @param $loop
	 * @param $variation_data
	 * @param $variation
	 */
	public function variation_custom_field( $loop, $variation_data, $variation ) {
		echo '<div class="form-row form-row-full options">';
		woocommerce_wp_text_input(
			array(
				'id'          => '_provider_price[' . $variation->ID . ']',
				'label'       => 'قیمت تامین کننده',
				'placeholder' => '',
				'desc_tip'    => 'true',
				'description' => 'قیمت تامین کننده محصول را جهت نمایش در لیست مدیریت انبار وارد نمایید.',
				'value'       => get_post_meta( $variation->ID, '_provider_price', true )
			)
		);
		echo '</p>';
	}

	/**
	 * Save new fields for variations
	 *
	 * @param $post_id
	 */
	public function save_variation_custom_field( $post_id ) {
		$provider_price = $_POST['_provider_price'][ $post_id ];

		if ( $provider_price && ! empty( $provider_price ) ) {
			update_post_meta( $post_id, '_provider_price', esc_attr( $provider_price ) );
		} else {
			delete_post_meta( $post_id, '_provider_price' );
		}
	}
}