<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Send_Email {

	public static function auto_send() {
		$send_email = get_option( 'wc_wip_settings_send_email' );
		switch ( $send_email ) {
			case 'order_completed':
				add_action( 'woocommerce_order_status_completed', function ( $order_id ) {
					self::manual_send( $order_id );
				} );
				break;
			case 'payment_complete':
				/*add_action( 'woocommerce_new_order', function ( $order_id ) {
					self::manual_send( $order_id );
				} );*/
				add_action( 'woocommerce_thankyou', function ( $order_id ) {
					self::manual_send( $order_id );
				} );
				break;
		}
	}

	public static function manual_send( $order_id ) {
		$order = wc_get_order( $order_id );
		if ( $order ) {
			$email = $order->get_billing_email();
			self::send( $email, $order_id );

			$receivers = get_option( 'wc_wip_settings_receivers_email' );
			if ( $receivers && ! empty( $receivers ) ) {
				$receivers = explode( ',', $receivers );
				foreach ( $receivers as $receiver ) {
					self::send( $receiver, $order_id );
				}
			}
		}
	}

	private static function send( $email, $order_id ) {
		add_filter( 'wp_mail_content_type', function () {
			return "text/html";
		} );
		add_filter( 'wp_mail_from', function ( $original_email_address ) {
			$email_from = get_option( 'wc_wip_settings_email_from' );
			$email_from = $email_from ? $email_from : get_bloginfo( 'admin_email' );

			return $email_from;
		} );
		add_filter( 'wp_mail_from_name', function ( $original_email_from ) {
			return get_bloginfo( 'name' );
		} );
		$print_invoice = new WIP_Print_Invoice( $order_id );
		wp_mail( $email, 'فاکتور خرید', $print_invoice->generate_template( false, false, true ) );
	}
}