<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WIP_Shop_Order_MTB {

	public static function init() {
		add_action( 'add_meta_boxes', array( self::class, 'add' ) );
		add_action( 'save_post', array( self::class, 'save' ) );
	}

	public static function add() {
		add_meta_box(
			'woocommerce-invoice-pro',
			'صدور فاکتور',
			array( self::class, 'display' ),
			'shop_order',
			'side',
			'low'
		);
		add_meta_box(
			'wip-active-for-seller',
			'دسترسی فروشنده',
			array( self::class, 'display_seller' ),
			'shop_order',
			'side',
			'low'
		);
	}

	public static function display( $post ) {
		echo '<a style="width:162px; text-align:center" class="button" target="_blank" href="' . esc_url( add_query_arg( array(
				'wip-print-invoice' => 1,
				'wip-print-type'    => 'invoice',
				'wip-order-id'      => $post->ID,
				'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
			), admin_url() ) ) . '">برگه فاکتور</a>';
		echo '<br><br>';
		echo '<a style="width:162px; text-align:center" class="button" target=_blank"" href="' . esc_url( add_query_arg( array(
				'wip-print-invoice' => 1,
				'wip-print-type'    => 'packing-slip',
				'wip-order-id'      => $post->ID,
				'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
			), admin_url() ) ) . '">برگه انبارداری</a>';
		echo '<br><br>';
		echo '<a style="width:162px; text-align:center" class="button" target=_blank"" href="' . esc_url( add_query_arg( array(
				'wip-print-invoice' => 1,
				'wip-print-type'    => 'post-label',
				'wip-order-id'      => $post->ID,
				'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
			), admin_url() ) ) . '">برچسب پستی</a>';
		echo '<br><br>';
		echo '<a style="width:162px; text-align:center" class="button" target=_blank"" href="' . esc_url( add_query_arg( array(
				'wip-print-invoice' => 1,
				'wip-print-type'    => 'sender-post-label',
				'wip-order-id'      => $post->ID,
				'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
			), admin_url() ) ) . '">برچسب پستی فرستنده</a>';
		echo '<br><br>';
		echo '<a style="width:162px; text-align:center" class="button" target=_blank"" href="' . esc_url( add_query_arg( array(
				'wip-print-invoice' => 1,
				'wip-print-type'    => 'recipient-post-label',
				'wip-order-id'      => $post->ID,
				'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
			), admin_url() ) ) . '">برچسب پستی گیرنده</a>';
		echo '<br><br>';
		echo '<a style="width:162px; text-align:center" href="#" class="wip-send-invoice button" data-order-id="' . $post->ID . '">ارسال برگه فاکتور</a>';
		echo '<img class="wip-ajax-loader" src="' . esc_url( admin_url() ) . 'images/spinner.gif" alt="Please wait…" style="margin: 5px; display: none;">';
	}

	public function display_seller( $post ) {
		$inactive = get_post_meta( $post->ID, '_wip_inactive_for_seller', true );
		?>
        <label for="inactive_for_seller">
            <input name="inactive-for-seller" type="checkbox" id="inactive-for-seller" value="1" <?php checked( $inactive, 1 ); ?>>
            <span>عدم دسترسی فروشنده</span>
        </label>
        <p class="description" style="margin-top: 7px;">
            <small>با انتخاب این گزینه فروشنده افزونه دکان به فاکتورهای این سفارش دسترسی نخواهد داشت.</small>
        </p>
		<?php
		wp_nonce_field( 'security', 'wip_mtb_nonce' );
	}

	public function save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( ! isset( $_POST['wip_mtb_nonce'] ) || ! wp_verify_nonce( $_POST['wip_mtb_nonce'], 'security' ) ) {
			return;
		}

		if ( ! current_user_can( 'edit_post' ) ) {
			return;
		}

		if ( ! isset( $_POST['inactive-for-seller'] ) || empty( $_POST['inactive-for-seller'] ) ) {
			delete_post_meta( $post_id, '_wip_inactive_for_seller' );
		} else {
			update_post_meta( $post_id, '_wip_inactive_for_seller', 1 );
		}
	}
}

/**
 * Initialize function for class and hook it to wordpress init action
 */
add_action( 'init', 'wip_zhk_grd_init' );
function wip_zhk_grd_init() {
	$settings = [
		'name'          => '<strong>افزونه صدور فاکتور حرفه‌ای ووکامرس</strong>',
		'slug'          => 'wip_zhk_guard_register',
		'parent_slug'   => 'wip-orders',
		// Read this: https://developer.wordpress.org/reference/functions/add_submenu_page/#parameters
		'text_domain'   => 'your-text-domain',
		'product_token' => '807cb5b0-6dcd-4eb8-a133-6848cb977a44',
		'option_name'   => 'wip_zhk_guard_register'
	];
	WIP_Plugin_SDK::instance( $settings );

	if ( WIP_Plugin_SDK::is_activated() !== true ) {
		if ( is_admin() ) {
			if ( ( isset( $_GET['wip-print-invoice'] ) && $_GET['wip-print-invoice'] == 1 )
			     || ( isset( $_GET['wip-print-orders'] ) && $_GET['wip-print-orders'] == 1 )
			     || ( isset( $_GET['page'] ) && $_GET['page'] == 'wip-orders' ) ) {
				wp_die( 'لطفا کلید لایسنس <strong>افزونه صدور فاکتور حرفه‌ای ووکامرس</strong> را وارد نمایید.' );
			}
		}
	}
}