<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

if ( get_option( 'wc_wip_settings_national_id' ) != 'yes' ) {
	return;
}

/**
 * Add national ID field to checkout form
 */
add_filter( 'woocommerce_checkout_fields', 'wip_checkout_fields_national_id' );
function wip_checkout_fields_national_id( $fields ) {
	$fields['billing']['billing_national_id'] = array(
		'label'       => 'شماره ملی/کد اقتصادی',
		'placeholder' => _x( 'شماره ملی/کد اقتصادی', 'placeholder', 'woocommerce' ),
		'required'    => true,
		'class'       => array( 'form-row-wide' ),
		'clear'       => true
	);

	return $fields;
}

/**
 * Display national ID value on the order edit page
 */
add_action( 'woocommerce_admin_order_data_after_billing_address', 'wip_checkout_field_national_id_display_admin_order_meta', 10, 1 );
function wip_checkout_field_national_id_display_admin_order_meta( $order ) {
	echo '<p><strong>شماره ملی/کد اقتصادی: </strong> ' . get_post_meta( $order->get_id(), '_billing_national_id', true ) . '</p>';
}