<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Add custom filed to woocommerce inventory tab
 */
add_action( 'woocommerce_product_options_inventory_product_data', 'wip_add_custom_inventory_fields' );
function wip_add_custom_inventory_fields() {
	global $woocommerce, $post;

	echo '<div class="options_group">';
	woocommerce_wp_text_input(
		array(
			'id'                => '_wip_cabinet_code',
			'label'             => 'کد قفسه انبار',
			'placeholder'       => '',
			'desc_tip'          => 'true',
			'description'       => 'جهت سهولت در پیدا کردن موقعیت محصول در قفسه انبار کد قفسه محصول را وارد کنید. (افزونه صدور حرفه‌ای فاکتور)',
			'custom_attributes' => array(
				'dir' => 'ltr',
			),
		)
	);
	echo '</div>';
}

/**
 * Save inventory custom filed
 */
add_action( 'woocommerce_process_product_meta', 'wip_add_custom_inventory_fields_save' );
function wip_add_custom_inventory_fields_save( $post_id ) {
	$cabinet_code = sanitize_text_field( $_POST['_wip_cabinet_code'] );

	if ( $cabinet_code && ! empty( $cabinet_code ) ) {
		update_post_meta( $post_id, '_wip_cabinet_code', $cabinet_code );
	} else {
		delete_post_meta( $post_id, '_wip_cabinet_code' );
	}
}