<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_filter( 'woocommerce_my_account_my_orders_actions', 'wip_add_my_account_order_actions', 10, 2 );
function wip_add_my_account_order_actions( $actions, $order ) {
	if ( get_option( 'wc_wip_settings_proforma_invoice' ) == 'yes' ) {
		$arg = array(
			'wip-print-invoice' => 1,
			'wip-order-id'      => $order->get_id(),
			'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
		);

		$status = $order->get_status();
		if ( get_option( 'wc_wip_settings_proforma_invoice_access' ) == 'yes' ) {
			if ( $status != 'completed' ) {
				return $actions;
			}
		}

		$actions['wip-print-invoice'] = array(
			'url'  => add_query_arg( $arg, home_url() ),
			'name' => 'چاپ برگه فاکتور',
		);
	}

	return $actions;
}

add_action( 'init', function () {
	if (
		! is_admin() &&
		isset( $_GET['wip-print-invoice'] ) && $_GET['wip-print-invoice'] == 1
		&& isset( $_GET['wip-order-id'] ) && ctype_digit( $_GET['wip-order-id'] )
		&& isset( $_GET['_wip_nonce'] ) && ! empty( $_GET['_wip_nonce'] )
	) {
		$order = wc_get_order( $_GET['wip-order-id'] );

		if ( get_current_user_id() != $order->user_id ) {
			exit();
		}

		$status = $order->get_status();
		if ( get_option( 'wc_wip_settings_proforma_invoice_access' ) == 'yes' ) {
			if ( $status != 'completed' ) {
				return exit();
			}
		}

		$nonce = $_REQUEST['_wip_nonce'];
		if ( ! wp_verify_nonce( $nonce, '_wip_nonce' ) ) {
			die( 'دسترسی غیر مجاز!' );
		} else {
			$print_invoice = new WIP_Print_Invoice( $_GET['wip-order-id'] );
			echo $print_invoice->generate_template();
		}

		exit();
	}
} );