<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'admin_init', function () {
	if (
		isset( $_GET['wip-print-invoice'] ) && $_GET['wip-print-invoice'] == 1
		&& isset( $_GET['wip-print-type'] ) && in_array( $_GET['wip-print-type'], array(
			'invoice',
			'packing-slip',
			'post-label',
			'sender-post-label',
			'recipient-post-label',
		) )
		&& isset( $_GET['wip-order-id'] ) && ctype_digit( $_GET['wip-order-id'] )
		&& isset( $_GET['_wip_nonce'] ) && ! empty( $_GET['_wip_nonce'] )
	) {
		$nonce = $_REQUEST['_wip_nonce'];
		if ( ! wp_verify_nonce( $nonce, '_wip_nonce' ) ) {
			die( 'دسترسی غیر مجاز!' );
		} else {
			$inactive = get_post_meta( $_GET['wip-order-id'], '_wip_inactive_for_seller', true );
			if ( $inactive && isset( $_GET['is_vendor'] ) ) {
				exit();
			}

			$print_invoice = new WIP_Print_Invoice( $_GET['wip-order-id'] );

			switch ( $_GET['wip-print-type'] ) {
				case 'invoice':
					echo $print_invoice->generate_template();
					break;
				case 'packing-slip':
					echo $print_invoice->generate_template( true, true );
					break;
				case 'post-label':
					$print_post_label = new WIP_Print_Post_Label( $_GET['wip-order-id'] );
					echo $print_post_label->generate_template();
					break;
				case 'sender-post-label':
					$print_sender_post_label = new WIP_Print_Sender_Post_Label( $_GET['wip-order-id'] );
					echo $print_sender_post_label->generate_template();
					break;
				case 'recipient-post-label':
					$print_recipient_post_label = new WIP_Print_Recipient_Post_Label( $_GET['wip-order-id'] );
					echo $print_recipient_post_label->generate_template();
					break;
			}
		}

		exit();
	}

	if ( isset( $_GET['wip-print-orders'] ) && $_GET['wip-print-orders'] == 1 ) {
		$nonce = $_REQUEST['_wip_nonce'];
		if ( ! wp_verify_nonce( $nonce, '_wip_nonce' ) ) {
			die( 'دسترسی غیر مجاز!' );
		} else {
			$print_orders = new WIP_Print_Orders( 1 );
			echo $print_orders->generate_template();

			exit();
		}
	}
} );