<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_filter( 'woocommerce_admin_order_actions', function ( $actions, $order ) {
	$order_id = method_exists( $order, 'get_id' ) ? $order->get_id() : $order->id;

	$inactive = get_post_meta( $order_id, '_wip_inactive_for_seller', true );
	if ( $inactive && wip_is_dokan_dashboard_page() ) {
		return $actions;
	}

	$invoice_args = array(
		'wip-print-invoice' => 1,
		'wip-print-type'    => 'invoice',
		'wip-order-id'      => $order_id,
		'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
	);

	$packing_slip_args = array(
		'wip-print-invoice' => 1,
		'wip-print-type'    => 'packing-slip',
		'wip-order-id'      => $order_id,
		'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
	);

	$post_label_args = array(
		'wip-print-invoice' => 1,
		'wip-print-type'    => 'post-label',
		'wip-order-id'      => $order_id,
		'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
	);

	$sender_post_label_args = array(
		'wip-print-invoice' => 1,
		'wip-print-type'    => 'sender-post-label',
		'wip-order-id'      => $order_id,
		'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
	);

	$recipient_post_label_args = array(
		'wip-print-invoice' => 1,
		'wip-print-type'    => 'recipient-post-label',
		'wip-order-id'      => $order_id,
		'_wip_nonce'        => wp_create_nonce( '_wip_nonce' ),
	);

	if ( wip_is_dokan_dashboard_page() && get_option( 'wc_wip_settings_vendor_addr' ) == 'yes' ) {
		$invoice_args['is_vendor']              = 1;
		$packing_slip_args['is_vendor']         = 1;
		$post_label_args['is_vendor']           = 1;
		$sender_post_label_args['is_vendor']    = 1;
		$recipient_post_label_args['is_vendor'] = 1;
	}

	$actions['wip-print-invoice'] = array(
		'url'    => esc_url( add_query_arg( $invoice_args, admin_url() ) ),
		'name'   => 'برگه فاکتور',
		'action' => "wip-print-invoice",
	);

	$actions['wip-print-packing-slip'] = array(
		'url'    => esc_url( add_query_arg( $packing_slip_args, admin_url() ) ),
		'name'   => 'برگه انبارداری',
		'action' => "wip-print-packing-slip",
	);

	$actions['wip-print-post-label'] = array(
		'url'    => esc_url( add_query_arg( $post_label_args, admin_url() ) ),
		'name'   => 'برچسب پستی',
		'action' => "wip-print-post-label",
	);

	$tiny_post_label = get_option( 'wc_wip_settings_tiny_post_label' );
	if ( ! $tiny_post_label || $tiny_post_label == 'no' ) {
		$actions['wip-print-sender-post-label'] = array(
			'url'    => esc_url( add_query_arg( $sender_post_label_args, admin_url() ) ),
			'name'   => 'برچسب پستی فرستنده',
			'action' => "wip-print-sender-post-label",
		);

		$actions['wip-print-recipient-post-label'] = array(
			'url'    => esc_url( add_query_arg( $recipient_post_label_args, admin_url() ) ),
			'name'   => 'برچسب پستی گیرنده',
			'action' => "wip-print-recipient-post-label",
		);
	}

	return $actions;
}, 100, 2 );

add_action( 'admin_head', function () {
	$style = '<style>';
	$style .= '.wip-print-invoice::after {content: "\\f535"}';
	$style .= '.wip-print-packing-slip::after {content: "\\f480"}';
	$style .= '.wip-print-post-label::after {content: "\\f466"}';
	$style .= '.wip-print-sender-post-label::after {content: "\\f513"}';
	$style .= '.wip-print-recipient-post-label::after {content: "\\f110"}';
	$style .= '</style>';
	echo $style . PHP_EOL;
} );