<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_filter( 'woocommerce_get_settings_pages', 'wip_add_settings', 15 );
function wip_add_settings() {

	/**
	 * Settings class
	 */
	class WIP_Settings_Tab_SRezaSalehi extends WC_Settings_Page {

		/**
		 * Setup settings class
		 */
		public function __construct() {

			$this->id    = 'woo_invoice_pro';
			$this->label = 'فاکتور';

			add_filter( 'woocommerce_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
			add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
			add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
			add_action( 'woocommerce_sections_' . $this->id, array( $this, 'output_sections' ) );
		}

		/**
		 * Get sections
		 *
		 * @return array
		 */
		public function get_sections() {

			$sections = array(
				''         => 'فروشگاه',
				'customer' => 'مشتری',
				'template' => 'قالب',
				'others'   => 'متفرقه',
			);

			return apply_filters( 'woocommerce_get_sections_' . $this->id, $sections );
		}

		/**
		 * Get settings array
		 *
		 * @param string $current_section Optional. Defaults to empty string.
		 *
		 * @return array Array of settings
		 */
		public function get_settings( $current_section = '' ) {

			if ( $current_section == 'customer' ) {
				$settings = apply_filters( 'woo_invoice_pro_customer_settings', array(
					'customer_info_title'    => array(
						'name' => 'اطلاعات مشتری',
						'type' => 'title',
						'id'   => 'wc_wip_settings_customer_info_title'
					),
					'customer_address'       => array(
						'name' => 'آدرس خریدار',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_customer_address',
						'desc' => 'نمایش',
					),
					'customer_phone'         => array(
						'name' => 'تلفن خریدار',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_customer_phone',
						'desc' => 'نمایش',
					),
					'customer_email'         => array(
						'name' => 'ایمیل خریدار',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_customer_email',
						'desc' => 'نمایش',
					),
					'order_date'             => array(
						'name' => 'تاریخ سفارش',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_order_date',
						'desc' => 'نمایش',
					),
					'shipping_method'        => array(
						'name' => 'روش پرداخت',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_shipping_method',
						'desc' => 'نمایش',
					),
					'transaction_id'         => array(
						'name' => 'شماره تراکنش',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_transaction_id',
						'desc' => 'نمایش',
					),
					'order_table'            => array(
						'name' => 'جدول سفارش',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_order_table',
						'desc' => 'نمایش',
					),
					'total_table'            => array(
						'name' => 'جدول کل',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_total_table',
						'desc' => 'نمایش',
					),
					'customer_note'          => array(
						'name'    => 'یادداشت مشتری',
						'type'    => 'select',
						'id'      => 'wc_wip_settings_customer_note',
						'class'   => 'wc-enhanced-select',
						'options' => array(
							'both'         => 'هردو',
							'none'         => 'هیچکدام',
							'invoice'      => 'فاکتور',
							'packing_slip' => 'برگه انبارداری',
						),
					),
					'national_id'            => array(
						'name'     => 'شماره ملی/کد اقتصادی',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_national_id',
						'desc'     => 'فعال',
						'desc_tip' => 'با فعال بودن این گزینه مستقل از قالب فعلی شما فیلد شماره ملی به فرم تسویه حساب اضافه خواهد شد و در فاکتور نیز قابل نمایش می‌باشد.',
					),
					'optimize_customer_addr' => array(
						'name'     => 'بهینه‌سازی آدرس',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_optimize_customer_addr',
						'desc'     => 'فعال',
						'desc_tip' => 'جهت بهینه سازی نمایش آدرس مشتری این گزینه را فعال نمایید.',
					),
					'customer_info_end'      => array(
						'type' => 'sectionend',
						'id'   => 'wc_wip_settings_customer_info_end'
					),
				) );
			} elseif ( $current_section == 'template' ) {
				$settings = apply_filters( 'woo_invoice_pro_template_settings', array(
					'template_title'               => array(
						'name' => 'پیکربندی قالب',
						'type' => 'title',
						'id'   => 'wc_wip_settings_footer_title'
					),
					'tpl_color'                    => array(
						'name'    => 'رنگ قالب',
						'type'    => 'select',
						'id'      => 'wc_wip_settings_tpl_color',
						'class'   => 'wc-enhanced-select',
						'options' => array(
							'484848' => 'خاکستری',
							'27ae60' => 'سبز 1',
							'16a085' => 'سبز 2',
							'00cec9' => 'سبزآبی',
							'2980b9' => 'آبی',
							'e74c3c' => 'قرمز',
							'ffa502' => 'نارنجی',
							'fff200' => 'زرد',
						),
					),
					'template'                     => array(
						'name'    => 'قالب',
						'type'    => 'select',
						'class'   => 'wc-enhanced-select',
						'id'      => 'wc_wip_settings_template',
						'options' => array(
							'template1' => 'قالب شماره 1',
							'template2' => 'قالب شماره 2',
							'template3' => 'قالب شماره 3',
						),
					),
					'font_family'                  => array(
						'name'     => 'نوع فونت',
						'type'     => 'select',
						'class'    => 'wc-enhanced-select',
						'id'       => 'wc_wip_settings_font_family',
						'options'  => array(
							''         => 'لطفا انتخاب کنید.',
							'vazir'    => 'وزیر',
							'yekan'    => 'یکان',
							'bnazanin' => 'نازنین',
							'bkoodak'  => 'کودک',
							'IRANSans' => 'ایران سنس',
						),
						'desc_tip' => 'جهت استفاده از فونت ایران سنس، فایل فونت را با فرمت های eot,ttf,woff,woff2 و نام IRANSans در پوشه assets/fonts/iransans قرار دهید.',
					),
					'font_size'                    => array(
						'name'              => 'اندازه فونت',
						'type'              => 'number',
						'id'                => 'wc_wip_settings_font_size',
						'custom_attributes' => array(
							'dir'  => 'ltr',
							'step' => '1',
							'min'  => '12',
							'max'  => '26',
						)
					),
					'invoice_prefix'               => array(
						'name'              => 'پیشوند شماره فاکتور',
						'type'              => 'text',
						'desc_tip'          => 'برای شماره فاکتور یک پیشوند انتخاب کنید.',
						'id'                => 'wc_wip_settings_invoice_prefix',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'invoice_suffix'               => array(
						'name'              => 'پسوند شماره فاکتور',
						'type'              => 'text',
						'desc_tip'          => 'برای شماره فاکتور یک پسوند انتخاب کنید.',
						'id'                => 'wc_wip_settings_invoice_suffix',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'invoice_start'                => array(
						'name'              => 'شماره شروع فاکتور',
						'type'              => 'number',
						'desc_tip'          => 'این عدد به تمامی شماره فاکتور ها اضافه خواهد شد.',
						'id'                => 'wc_wip_settings_invoice_start',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'barcode'                      => array(
						'name' => 'بارکد',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_barcode',
						'desc' => 'نمایش',
					),
					'barcode_sender_post_label'    => array(
						'name' => 'نمایش بارکد در برچسب فرستنده',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_barcode_sender_post_label',
						'desc' => 'نمایش',
					),
					'barcode_recipient_post_label' => array(
						'name' => 'نمایش بارکد در برچسب گیرنده',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_barcode_recipient_post_label',
						'desc' => 'نمایش',
					),
					'condensed'                    => array(
						'name'     => 'حالت فشرده',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_condensed',
						'desc'     => 'فعال',
						'desc_tip' => 'درصورتی که از برگه A5 استفاده میکنید میتوانید این گزینه را فعال کنید.',
					),
					'margin'                       => array(
						'name'              => 'فاصله از لبه',
						'type'              => 'number',
						'desc_tip'          => 'فاصله فاکتور از لبه برگه را به پیکسل وارد کنید.',
						'id'                => 'wc_wip_settings_margin',
						'custom_attributes' => array(
							'dir'  => 'ltr',
							'step' => '1',
							'min'  => '0',
						)
					),
					'price_type'                   => array(
						'name'    => 'قیمت محصول',
						'type'    => 'select',
						'class'   => 'wc-enhanced-select',
						'id'      => 'wc_wip_settings_price_type',
						'options' => array(
							'sale'         => 'قیمت فروش فوق‌العاده',
							'regular_sale' => 'قیمت اصلی + قیمت فروش فوق‌العاده',
						),
					),
					'price'                        => array(
						'name'    => 'نمایش قیمت محصول',
						'type'    => 'select',
						'class'   => 'wc-enhanced-select',
						'id'      => 'wc_wip_settings_price',
						'options' => array(
							'both'         => 'هردو',
							'none'         => 'هیچکدام',
							'invoice'      => 'فاکتور',
							'packing_slip' => 'برگه انبارداری',
						),
					),
					'weight'                       => array(
						'name'     => 'وزن محصول',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_weight',
						'desc'     => 'نمایش',
						'desc_tip' => 'وزن محصول فقط در برگه انبارداری نمایش داده میشود.',
					),
					'dimensions'                   => array(
						'name'     => 'ابعاد محصول',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_dimensions',
						'desc'     => 'نمایش',
						'desc_tip' => 'ابعاد محصول فقط در برگه انبارداری نمایش داده میشود.',
					),
					'cabinet_code'                 => array(
						'name'     => 'کد قفسه انبار',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_cabinet_code',
						'desc'     => 'نمایش',
						'desc_tip' => 'با اختصاص کد قفسه انبار برای محصولات در تب انبار، این کد در برگه انبارداری نمایش داده میشود.',
					),
					'product_id'                   => array(
						'name'     => 'شناسه',
						'type'     => 'radio',
						'id'       => 'wc_wip_settings_product_id',
						'options'  => array(
							'p_id'  => 'شناسه محصول',
							'p_sku' => 'شناسه اختصاصی محصول',
						),
						'desc_tip' => 'منظور از شناسه اختصاصی محصول، شناسه ای است که در تب انبار وارد میکنید. اگر این شناسه موجود نباشد شناسه محصول جایگزین میشود.',
					),
					'show_product_id'              => array(
						'name'    => 'نمایش شناسه محصول',
						'type'    => 'select',
						'class'   => 'wc-enhanced-select',
						'id'      => 'wc_wip_settings_show_product_id',
						'options' => array(
							'both'         => 'هردو',
							'none'         => 'هیچکدام',
							'invoice'      => 'فاکتور',
							'packing_slip' => 'برگه انبارداری',
						),
					),
					'total_quantity'               => array(
						'name' => 'تعداد کل اقلام',
						'type' => 'checkbox',
						'id'   => 'wc_wip_settings_total_quantity',
						'desc' => 'نمایش',
					),
					'discount_amount'              => array(
						'name'     => 'تخفیف کل محصولات',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_discount_amount',
						'desc'     => 'نمایش',
						'desc_tip' => 'تخفیف کل محصولات با عنوان "سود شما از این خرید" نمایش داده میشود.',
					),
					'tax'                          => array(
						'name'     => 'مالیات',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_tax',
						'desc'     => 'نمایش',
						'desc_tip' => 'با فعال بودن این گزینه در صورتی که نرخ استاندارد مالیات داشته باشید، در جدول کل نمایش داده میشود.',
					),
					'signature'                    => array(
						'name'              => 'مهر و امضا',
						'type'              => 'text',
						'class'             => 'select-uploader',
						'desc'              => '',
						'desc_tip'          => 'تصویر مهر و امضا فروشگاه خود را جهت نمایش در فاکتور انتخاب کنید.',
						'id'                => 'wc_wip_settings_signature',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'refunded_items'               => array(
						'name'     => 'محصولات مسترد شده',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_refunded_items',
						'desc'     => 'فعال',
						'desc_tip' => 'چنانچه محصولی را از سفارش مسترد شده باشید، تعداد و مبلغ برای هر محصول بصورت مجزا در فاکتور نمایش داده خواهد شد.',
					),
					'product_img'                  => array(
						'name'    => 'تصویر محصول',
						'type'    => 'select',
						'id'      => 'wc_wip_settings_product_img',
						'class'   => 'wc-enhanced-select',
						'options' => array(
							'none'         => 'هیچکدام',
							'both'         => 'هردو',
							'invoice'      => 'فاکتور',
							'packing_slip' => 'برگه انبارداری',
						),
					),
					'watermark'                    => array(
						'name'              => 'واترمارک',
						'type'              => 'text',
						'class'             => 'select-uploader',
						'desc'              => '',
						'desc_tip'          => 'یک تصویر برای واترمارک انتخاب نمایید.',
						'id'                => 'wc_wip_settings_watermark',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'watermark_opacity'            => array(
						'name'              => 'شفافیت واترمارک',
						'type'              => 'number',
						'desc_tip'          => 'مقدار شفافیت تصویر واترمارک را عددی بین 0 تا 1 وارد نمایید.',
						'id'                => 'wc_wip_settings_watermark_opacity',
						'custom_attributes' => array(
							'dir'  => 'ltr',
							'step' => '0.1',
							'min'  => '0',
							'max'  => '1',
						)
					),
					'product_name_optimize'        => array(
						'name'     => 'بهینه‌سازی نام محصول',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_product_name_optimize',
						'desc'     => 'فعال',
						'desc_tip' => 'چنانچه نام محصولات متغییر به درستی نمایش داده نمیشود، این گزینه را فعال کنید.'
					),
					'template_end'                 => array(
						'type' => 'sectionend',
						'id'   => 'wc_wip_settings_footer_end'
					),
				) );
			} elseif ( $current_section == 'others' ) {
				$settings = apply_filters( 'woo_invoice_pro_others_settings', array(
					'others_title'            => array(
						'name' => 'متفرقه',
						'type' => 'title',
						'id'   => 'wc_wip_settings_others_title'
					),
					'send_email'              => array(
						'name'     => 'ارسال فاکتور',
						'type'     => 'radio',
						'id'       => 'wc_wip_settings_send_email',
						'options'  => array(
							'manual'           => 'ارسال دستی',
							'order_completed'  => 'ارسال خودکار (پس از تکمیل سفارش)',
							'payment_complete' => 'ارسال خودکار (پس از تکمیل پرداخت)',
						),
						'desc_tip' => 'از این گزینه جهت ارسال فاکتور HTML به ایمیل خریدار استفاده نمایید.',
					),
					'address_type'            => array(
						'name'     => 'سفارش',
						'type'     => 'select',
						'class'    => 'wc-enhanced-select',
						'id'       => 'wc_wip_settings_address_type',
						'options'  => array(
							'billing'  => 'آدرس صورتحساب',
							'shipping' => 'آدرس حمل و نقل',
						),
						'desc_tip' => 'با انتخاب آدرس حمل و نقل، اگر این آدرس موجود نباشد آدرس صورتحساب جایگزین میشود.',
					),
					'footer_description'      => array(
						'name'              => 'توضیحات پانوشت',
						'type'              => 'textarea',
						'id'                => 'wc_wip_settings_footer_description',
						'desc_tip'          => 'این متن در پایین فاکتور نمایش داده میشود.',
						'custom_attributes' => array(
							'rows' => '5',
						)
					),
					'proforma_invoice'        => array(
						'name'     => 'پیش فاکتور',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_proforma_invoice',
						'desc'     => 'فعال',
						'desc_tip' => 'با فعال بودن این گزینه دکمه چاپ فاکتور در جدول سفارشات مشتری فعال میشود.',
					),
					'proforma_invoice_access' => array(
						'name'     => 'محدودیت دسترسی به پیش فاکتور',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_proforma_invoice_access',
						'desc'     => 'فعال',
						'desc_tip' => 'با فعال بودن این گزینه فقط سفارشات با وضعیت تکمیل شده قابلیت دریافت پیش فاکتور را دارند.',
					),
					'vendor_addr'             => array(
						'name'     => 'آدرس فروشنده',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_vendor_addr',
						'desc'     => 'فعال',
						'desc_tip' => 'با فعال بودن این گزینه چنانچه از افزونه چند فروشندگی دکان استفاده میکنید، آدرس فروشنده با آدرس فروشگاه جایگزین میشود.',
					),
					'tiny_post_label'         => array(
						'name'     => 'برچسب های کوچک فرستنده و گیرنده',
						'type'     => 'checkbox',
						'id'       => 'wc_wip_settings_tiny_post_label',
						'desc'     => 'مخفی',
						'desc_tip' => 'با فعال بودن این گزینه آیکن برچسب های کوچک فرستنده و گیرنده در جدول سفارشات مخفی خواهد شد.',
					),
					'email_from'              => array(
						'name'              => 'ایمیل ارسال کننده',
						'type'              => 'email',
						'id'                => 'wc_wip_settings_email_from',
						'desc_tip'          => 'این ایمیل در Header ایمیل های ارسالی نمایش داده خواهد شد. در صورتی که این فیلد را خالی رها کنید، ایمیل مدیر جایگزین خواهد شد.',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'receivers_email'         => array(
						'name'              => 'ایمیل گیرنده‌گان',
						'type'              => 'email',
						'id'                => 'wc_wip_settings_receivers_email',
						'desc_tip'          => 'ایمیل گیرنده‌گان فاکتور را با کامای انگلیسی از هم جدا کنید.',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'others_end'              => array(
						'type' => 'sectionend',
						'id'   => 'wc_wip_settings_others_end'
					),
				) );
			} else {
				$settings = apply_filters( 'woo_invoice_pro_store_settings', array(
					'store_info_title' => array(
						'name' => 'اطلاعات فروشگاه',
						'type' => 'title',
						'id'   => 'wc_wip_settings_store_info_title'
					),
					'store_logo'       => array(
						'name'              => 'نشان فروشگاه',
						'type'              => 'text',
						'class'             => 'select-uploader',
						'desc'              => '',
						'desc_tip'          => 'نشان فروشگاه خود را جهت نمایش در فاکتور انتخاب کنید.',
						'id'                => 'wc_wip_settings_store_logo',
						'custom_attributes' => array( 'dir' => 'ltr', )
					),
					'store_title'      => array(
						'name' => 'عنوان فروشگاه',
						'type' => 'text',
						'id'   => 'wc_wip_settings_store_title'
					),
					'store_url'        => array(
						'name'              => 'وب سایت فروشگاه',
						'type'              => 'text',
						'id'                => 'wc_wip_settings_store_url',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'store_postcode'   => array(
						'name'              => 'کد پستی فروشگاه',
						'type'              => 'text',
						'id'                => 'wc_wip_settings_store_postcode',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'store_email'      => array(
						'name'              => 'ایمیل فروشگاه',
						'type'              => 'email',
						'id'                => 'wc_wip_settings_store_email',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'store_phone'      => array(
						'name'              => 'تلفن فروشگاه',
						'type'              => 'text',
						'id'                => 'wc_wip_settings_store_phone',
						'custom_attributes' => array(
							'dir' => 'ltr',
						)
					),
					'store_address'    => array(
						'name'     => 'آدرس فروشگاه',
						'type'     => 'textarea',
						'id'       => 'wc_wip_settings_store_address',
						'desc_tip' => 'آدرس  پستی کامل فروشگاه خود را بدون کد پستی وارد کنید. جهت عدم نمایش آدرس فروشگاه این فیلد را خالی رها کنید.',
					),
					'store_info_end'   => array(
						'type' => 'sectionend',
						'id'   => 'wc_wip_settings_store_info_end'
					),
				) );
			}

			return apply_filters( 'woocommerce_get_settings_' . $this->id, $settings, $current_section );

		}

		/**
		 * Output the settings
		 */
		public function output() {

			global $current_section;

			$settings = $this->get_settings( $current_section );
			WC_Admin_Settings::output_fields( $settings );
		}

		/**
		 * Save settings
		 */
		public function save() {

			global $current_section;

			$settings = $this->get_settings( $current_section );
			WC_Admin_Settings::save_fields( $settings );
		}
	}

	return new WIP_Settings_Tab_SRezaSalehi();
}

class WIP_Plugin_SDK {

	/**
	 * Your plugin or theme name. It will be used in admin notices
	 * @var mixed
	 */
	private $name;
	/**
	 * Registration page slug
	 * @var mixed
	 */
	private $slug;
	/**
	 * Parent menu slug
	 * More info: https://developer.wordpress.org/reference/functions/add_submenu_page/
	 * @var mixed
	 */
	private $parent_slug;
	/**
	 * Your plugin or theme text domain
	 * This wil be used to translate Zhaket Guard SDK strings with you theme or plugin translation file
	 * @var mixed
	 */
	private $text_domain;
	/**
	 * Name of option that save info
	 * @var mixed
	 */
	private static $option_name;
	/**
	 * Your product token in zhaket.com
	 * @var mixed
	 */
	private $product_token;
	/**
	 * Zhaket guard API url
	 * @var string
	 */
	public static $api_url = 'http://guard.zhaket.com/api/';

	/**
	 * Single instance of class
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Zhaket_Guard_SDK constructor.
	 */
	public function __construct( array $settings ) {

		// Initial settings
		$defaults = [
			'name'          => '',
			'slug'          => 'zhk_guard_register',
			'parent_slug'   => 'irk-options',
			'text_domain'   => '',
			'product_token' => '',
			'option_name'   => 'zhk_guard_register_settings'
		];
		foreach ( $settings as $key => $setting ) {
			if ( array_key_exists( $key, $defaults ) && ! empty( $setting ) ) {
				$defaults[ $key ] = $setting;
			}
		}
		$this->name          = $defaults['name'];
		$this->slug          = $defaults['slug'];
		$this->parent_slug   = $defaults['parent_slug'];
		$this->text_domain   = $defaults['text_domain'];
		self::$option_name   = $defaults['option_name'];
		$this->product_token = $defaults['product_token'];

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );

		add_action( 'wp_ajax_' . $this->slug, array( $this, 'wp_starter' ) );

		add_action( 'wp_ajax_' . $this->slug . '_revalidate', array( $this, 'revalidate_starter' ) );

		add_action( 'init', array( $this, 'schedule_programs' ) );

		add_action( $this->slug . '_daily_validator', array( $this, 'daily_event' ) );

		add_action( 'admin_notices', array( $this, 'admin_notice' ) );

	}


	/**
	 * Add submenu page for display registration form
	 */
	public function admin_menu() {
		add_submenu_page(
			$this->parent_slug,
			'ثبت نسخه',
			'ثبت نسخه',
			'manage_options',
			$this->slug,
			array( $this, 'menu_content' )
		);
	}

	/**
	 * Submenu content
	 */
	public function menu_content() {
		$option  = get_option( self::$option_name );
		$now     = json_decode( get_option( $option ) );
		$starter = ( isset( $now->starter ) && ! empty( $now->starter ) ) ? base64_decode( $now->starter ) : '';
		if ( isset( $_GET['debugger'] ) && ! empty( $_GET['debugger'] ) && $_GET['debugger'] === 'show' ) {
			$data_show = $option;
		} else {
			$data_show = '';
		}
		?>
        <style>
            form.register_version_form,
            .current_license {
                width: 30%;
                background: #fff;
                margin: 0 auto;
                padding: 20px 30px;
            }

            form.register_version_form .license_key {
                padding: 5px 10px;
                width: calc(100% - 100px);
            }

            form.register_version_form button {
                width: 80px;
                text-align: center;
            }

            form.register_version_form .result,
            .current_license .check_result {
                width: 100%;
                padding: 30px 0 15px;
                text-align: center;
                display: none;
            }

            .current_license .check_result {
                padding: 20px 0;
                float: right;
                width: 100%;
            }

            form.register_version_form .result .spinner,
            .current_license .check_result .spinner {
                width: auto;
                background-position: right center;
                padding-right: 30px;
                margin: 0;
                float: none;
                visibility: visible;
                display: none;
            }

            .current_license.waiting .check_result .spinner,
            form.register_version_form .result.show .spinner {
                display: inline-block;
            }

            .current_license {
                width: 40%;
                text-align: center;
            }

            .current_license > .current_label {
                line-height: 25px;
                height: 25px;
                display: inline-block;
                font-weight: bold;
                margin-left: 10px;
            }

            .current_license > code {
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                color: #c7254e;
                margin-left: 10px;
                display: inline-block;
                -webkit-transform: translateY(2px);
                -moz-transform: translateY(2px);
                -ms-transform: translateY(2px);
                -o-transform: translateY(2px);
                transform: translateY(2px);
            }

            .current_license .action {
                color: #fff;
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                display: inline-block;
            }

            .current_license .last_check {
                line-height: 25px;
                height: 25px;
                padding: 0 5px;
                display: inline-block;
            }

            .current_license .action.active {
                background: #4CAF50;
            }

            .current_license .action.inactive {
                background: #c7254e;
            }

            .current_license .keys {
                float: right;
                width: 100%;
                text-align: center;
                padding-top: 20px;
                border-top: 1px solid #ddd;
                margin-top: 20px;
            }

            .current_license .keys .wpmlr_revalidate {
                margin-left: 30px;
            }

            .current_license .register_version_form {
                display: none;
                padding: 0;
                float: right;
                width: 80%;
                margin: 20px 10%;
            }

            .zhk_guard_notice {
                background: #fff;
                border: 1px solid rgba(0, 0, 0, .1);
                border-right: 4px solid #00a0d2;
                padding: 5px 15px;
                margin: 5px;
            }

            .zhk_guard_danger {
                background: #fff;
                border: 1px solid rgba(0, 0, 0, .1);
                border-right: 4px solid #DC3232;
                padding: 5px 15px;
                margin: 5px;
            }

            .zhk_guard_success {
                background: #fff;
                border: 1px solid rgba(0, 0, 0, .1);
                border-right: 4px solid #46b450;
                padding: 5px 15px;
                margin: 5px;
            }

            @media (max-width: 1024px) {
                form.register_version_form,
                .current_license {
                    width: 90%;
                }
            }
        </style>
        <div class="wrap wpmlr_wrap" data-show="<?php echo $data_show ?>">
            <h1>ثبت نسخه</h1>
			<?php if ( isset( $now ) && ! empty( $now ) ): ?>
                <p>شما قبلا کلید لایسنس خود را ثبت کرده اید. جهت اعتبارسنجی مجدد از این فرم استفاده کنید.</p>
                <div class="current_license">
                    <span class="current_label">لایسنس کنونی شما:</span>
                    <code><?php echo $starter; ?></code>
                    <div class="action <?php echo ( $now->action == 1 ) ? 'active' : 'inactive'; ?>">
						<?php if ( $now->action == 1 ): ?>
                            <span class="dashicons dashicons-yes"></span>
							<?php echo $now->message; ?>
						<?php else: ?>
                            <span class="dashicons dashicons-no-alt"></span>
							<?php echo $now->message; ?>
						<?php endif; ?>
                    </div>
                    <div class="keys">
                        <a href="#" class="button button-primary wpmlr_revalidate" data-key="<?php echo $starter; ?>">اعتبارسنجی مجدد</a>
                        <a href="#" class="button zhk_guard_new_key">حذف و ثبت لایسنس دیگر</a>
                    </div>

                    <form action="#" method="post" class="register_version_form">
                        <input type="text" class="license_key" placeholder="کلید لایسنس جدید">
                        <button class="button button-primary">ثبت نسخه</button>
                        <div class="result">
                            <div class="spinner">لطفا صبر کنید...</div>
                            <div class="result_text"></div>
                        </div>
                    </form>

                    <div class="check_result">
                        <div class="spinner">لطفا صبر کنید...</div>
                        <div class="result_text"></div>
                    </div>
                    <div class="clear"></div>
                </div>
			<?php else: ?>
                <p>جهت برخورداری از کلیه امکانات افزونه لطفا کلید لایسنس خود را ثبت کنید.</p>
                <form action="#" method="post" class="register_version_form">
                    <input type="text" class="license_key" placeholder="کلید لایسنس">
                    <button class="button button-primary">ثبت نسخه</button>
                    <div class="result">
                        <div class="spinner">لطفا صبر کنید...</div>
                        <div class="result_text"></div>
                    </div>
                </form>
			<?php endif; ?>
            <script>
                jQuery(document).ready(function ($) {
                    var ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
                    jQuery(document).on('submit', '.register_version_form', function (event) {
                        event.preventDefault();
                        var starter = jQuery(this).find('.license_key').val(),
                            thisEl = jQuery(this);
                        thisEl.addClass('waiting');
                        thisEl.find('.result').slideDown(300).addClass('show');
                        thisEl.find('.button').addClass('disabled');
                        thisEl.find('.result_text').slideUp(300).html('');
                        jQuery.ajax({
                            url: ajax_url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                action: '<?php echo $this->slug; ?>',
                                starter: starter
                            },
                        })
                            .done(function (result) {
                                thisEl.find('.result_text').append(result.data).slideDown(150)
                            })
                            .fail(function (result) {
                                thisEl.find('.result_text').append('<div class="zhk_grd_danger">خطایی رخ داده است. لطفا مجددا تلاش کنید!</div>').slideDown(150)
                            })
                            .always(function (result) {
                                console.log(result);
                                thisEl.removeClass('waiting');
                                thisEl.find('.result').removeClass('show');
                                thisEl.find('.button').removeClass('disabled');
                            });
                    });

                    $(document).on('click', '.wpmlr_revalidate', function (event) {
                        event.preventDefault();
                        var starter = $(this).data('key'),
                            thisEl = $(this).parents('.current_license');
                        thisEl.addClass('waiting');
                        thisEl.find('.check_result').slideDown(300);
                        thisEl.find('.button').addClass('disabled');
                        thisEl.find('.result_text').slideUp(300).html('');
                        thisEl.find('.register_version_form').slideUp(300)
                        $.ajax({
                            url: ajax_url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                action: '<?php echo $this->slug; ?>_revalidate',
                                starter: starter
                            },
                        })
                            .done(function (result) {
                                thisEl.find('.check_result .result_text').append(result.data).slideDown(150)
                            })
                            .fail(function (result) {
                                thisEl.find('.check_result .result_text').append('<div class="wpmlr_danger">خطایی رخ داده است. لطفا مجددا تلاش کنید!</div>').slideDown(150)
                            })
                            .always(function (result) {
                                thisEl.removeClass('waiting');
                                thisEl.find('.button').removeClass('disabled');
                            });
                    });


                    $(document).on('click', '.zhk_guard_new_key', function (event) {
                        event.preventDefault();
                        var thisEl = $(this).parents('.current_license');
                        thisEl.find('.result_text').slideUp(300).html('');
                        thisEl.find('.register_version_form').slideDown(300)
                    });
                });
            </script>

        </div>
		<?php

	}

	/**
	 *
	 */
	public function wp_starter() {
		$starter = sanitize_text_field( $_POST['starter'] );
		if ( empty( $starter ) ) {
			wp_send_json_error( '<div class="zhk_guard_danger">لطفا کد لایسنس خود را وارد کنید.</div>' );
		}

		$private_session = get_option( self::$option_name );
		delete_option( $private_session );

		$product_token = $this->product_token;
		$result        = self::install( $starter, $product_token );
		$output        = '';

		if ( $result->status == 'successful' ) {
			$rand_key = md5( wp_generate_password( 12, true, true ) );
			update_option( self::$option_name, $rand_key );
			$result = array(
				'starter' => base64_encode( $starter ),
				'action'  => 1,
				'message' => 'کد لایسنس معتبر است.',
				'timer'   => time(),
			);
			update_option( $rand_key, json_encode( $result ) );
			$output = '<div class="zhk_guard_success">با تشکر از شما، لایسنس شما با موفقیت فعال شد.</div>';
			wp_send_json_success( $output );
		} else {
			if ( ! is_object( $result->message ) ) {
				$output = '<div class="zhk_guard_danger">' . $result->message . '</div>';
				wp_send_json_error( $output );
			} else {
				foreach ( $result->message as $message ) {
					foreach ( $message as $msg ) {
						$output .= '<div class="zhk_guard_danger">' . $msg . '</div>';
					}
				}
				wp_send_json_error( $output );
			}
		}
	}

	/**
	 * Show admin notice for registration problems
	 */
	public function admin_notice() {
		$private_session = get_option( self::$option_name );
		$now             = json_decode( get_option( $private_session ) );
		?>
		<?php if ( empty( $now ) ): ?>
            <div class="notice notice-error">
                <p>
					<?php printf( 'جهت فعال سازی %s لطفا کلید لایسنس را وارد کنید.', $this->name ); ?>
                    <a href="<?php echo admin_url( 'admin.php?page=' . $this->slug ); ?>" class="button button-primary">ثبت</a>
                </p>
            </div>
		<?php elseif ( $now->action != 1 ): ?>
            <div class="notice notice-error">
                <p>
					<?php printf( 'چیزی با لایسنس %s شما اشتباه است. لطفا آنرا بررسی نمایید.', $this->name ); ?>
                    <a href="<?php echo admin_url( 'admin.php?page=' . $this->slug ); ?>" class="button button-primary">بررسی</a>
                </p>
            </div>
		<?php endif; ?>
		<?php
	}

	/**
	 *  Ajax callback for check license action
	 */
	public function revalidate_starter() {
		$starter = sanitize_text_field( $_POST['starter'] );
		if ( empty( $starter ) ) {
			wp_send_json_error( '<div class="zhk_guard_danger">لطفا کد لایسنس خود را وارد کنید.</div>' );
		}

		$result = self::is_valid( $starter );
		if ( $result->status == 'successful' ) {
			$rand_key = md5( wp_generate_password( 12, true, true ) );
			update_option( self::$option_name, $rand_key );
			$how = array(
				'starter' => base64_encode( $starter ),
				'action'  => 1,
				'message' => $result->message,
				'timer'   => time(),
			);
			update_option( $rand_key, json_encode( $how ) );
			$output = '<div class="zhk_guard_success">با تشکر از شما، لایسنس شما با موفقیت فعال شد.</div>';
			wp_send_json_success( $output );
		} else {
			$rand_key = md5( wp_generate_password( 12, true, true ) );
			update_option( self::$option_name, $rand_key );
			$how = array(
				'starter' => base64_encode( $starter ),
				'action'  => 0,
				'timer'   => time(),
			);
			if ( ! is_object( $result->message ) ) {
				$how['message'] = $result->message;
			} else {
				foreach ( $result->message as $message ) {
					foreach ( $message as $msg ) {
						$how['message'] = $msg;
					}
				}
			}
			update_option( $rand_key, json_encode( $how ) );
			$output = '<div class="zhk_guard_danger">' . $how['message'] . '</div>';
			wp_send_json_success( $output );
		}

	}

	/**
	 * Set a schedule event for daily checking
	 */
	public function schedule_programs() {
		if ( ! wp_next_scheduled( $this->slug . '_daily_validator' ) ) {
			wp_schedule_event( time(), 'daily', $this->slug . '_daily_validator' );
		}
	}

	/**
	 * Check license status every day
	 */
	public function daily_event() {
		$private_session = get_option( self::$option_name );
		$now             = json_decode( get_option( $private_session ) );
		if ( isset( $now ) && ! empty( $now ) ) {
			$starter = ( isset( $now->starter ) && ! empty( $now->starter ) ) ? base64_decode( $now->starter ) : '';
			$result  = self::is_valid( $starter );
			if ( $result != null ) {
				if ( $result->status == 'successful' ) {
					delete_option( $private_session );
					$rand_key = md5( wp_generate_password( 12, true, true ) );
					update_option( self::$option_name, $rand_key );
					$how = array(
						'starter' => base64_encode( $starter ),
						'action'  => 1,
						'message' => $result->message,
						'timer'   => time(),
					);
					update_option( $rand_key, json_encode( $how ) );
				} else {

					delete_option( $private_session );
					$rand_key = md5( wp_generate_password( 12, true, true ) );
					update_option( self::$option_name, $rand_key );
					$how = array(
						'starter' => base64_encode( $starter ),
						'action'  => 0,
						'timer'   => time(),
					);
					if ( ! is_object( $result->message ) ) {
						$how['message'] = $result->message;
					} else {
						foreach ( $result->message as $message ) {
							foreach ( $message as $msg ) {
								$how['message'] = $msg;
							}
						}
					}
					update_option( $rand_key, json_encode( $how ) );
				}
			}
		}
	}

	/**
	 * Check license status
	 * If you want add an interrupt in your plugin or theme simply can use this static method: Zhaket_Guard_SDK::is_activated
	 * This will return true or false for license status
	 * @return bool
	 */
	public static function is_activated() {
		$private_session = get_option( self::$option_name );
		$now             = json_decode( get_option( $private_session ) );
		if ( empty( $now ) ) {
			return false;
		} elseif ( $now->action != 1 ) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * @param $method
	 * @param array $params
	 *
	 * @return array|mixed|object
	 */
	public static function send_request( $method, $params = array() ) {
		$param_string = http_build_query( $params );
		$ch           = curl_init();
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_URL,
			self::$api_url . $method . '?' . $param_string
		);
		$content = curl_exec( $ch );

		return json_decode( $content );
	}

	/**
	 * @param $license_token
	 *
	 * @return array|mixed|object
	 */
	public static function is_valid( $license_token ) {
		$result = self::send_request( 'validation-license', array(
			'token'  => $license_token,
			'domain' => self::get_host()
		) );

		return $result;
	}

	/**
	 * @param $license_token
	 * @param $product_token
	 *
	 * @return array|mixed|object
	 */
	public static function install( $license_token, $product_token ) {
		$result = self::send_request( 'install-license', array(
			'product_token' => $product_token,
			'token'         => $license_token,
			'domain'        => self::get_host()
		) );

		return $result;
	}

	/**
	 * @return string
	 */
	public static function get_host() {
		$possibleHostSources   = array( 'HTTP_X_FORWARDED_HOST', 'HTTP_HOST', 'SERVER_NAME', 'SERVER_ADDR' );
		$sourceTransformations = array(
			"HTTP_X_FORWARDED_HOST" => function ( $value ) {
				$elements = explode( ',', $value );

				return trim( end( $elements ) );
			}
		);
		$host                  = '';
		foreach ( $possibleHostSources as $source ) {
			if ( ! empty( $host ) ) {
				break;
			}
			if ( empty( $_SERVER[ $source ] ) ) {
				continue;
			}
			$host = $_SERVER[ $source ];
			if ( array_key_exists( $source, $sourceTransformations ) ) {
				$host = $sourceTransformations[ $source ]( $host );
			}
		}

		// Remove port number from host
		$host = preg_replace( '/:\d+$/', '', $host );
		// remove www from host
		$host = str_ireplace( 'www.', '', $host );

		return trim( $host );
	}

	/**
	 * @param $settings
	 *
	 * @return null|Zhaket_Guard_SDK
	 */
	public static function instance( $settings ) {
		// Check if instance is already exists
		if ( self::$instance == null ) {
			self::$instance = new self( $settings );
		}

		return self::$instance;
	}

}
