<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>فاکتور</title>
    <style>
        /* Hide page header and footer when printing page*/
        @page {
            size: auto;
            margin: 0;
        }

        /* Show background color when printing*/
        @media print {
            body {
                -webkit-print-color-adjust: exact;
            }
        }

        /* Avoid extra blank page at end while printing */
        @media print {
            html, body {
                height: 99%;
                page-break-after: avoid;
                page-break-before: avoid;
            }
            .wip-invoice {
                page-break-after: auto;
            }
        }

        body {
            margin: ##margin##px;
            padding: 0;
        }

        ##font-face##

        .wip-invoice {
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 34px;
            direction: rtl;
            color: #000000;
            padding: 30px;
            margin: 0;
            position: relative;
        }

        .wip-is-email {
            border: 1px solid ##border-color##;
        }

        .d-none {
            display: none !important;
        }

        bdi {
            direction: ltr;
        }

        ins {
            display: block;
            text-decoration: none;
        }

        p {
            margin: 7px 0;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 34px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td, th {
            vertical-align: middle;
            padding: 4px;
            text-align: center;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        th {
            background: ##tpl-color##;
            font-weight: 500;
        }

        caption, strong {
            font-weight: bold;
        }

        .table-bordered td, .table-bordered th {
            border: 1px solid ##border-color##;
        }

        .shop-table {
            margin-bottom: 5px;
            border: 1px solid ##border-color##;
            width: 100%;
        }

        .barcode > div {
            margin: auto;
        }

        .shop-table tfoot td {
            background: ##tpl-color##;
        }

        .customer-info {
            border: 1px solid ##border-color##;
            padding: 10px;
            margin-bottom: 5px;
            background: ##tpl-color##;
        }

        .customer-info div {
            display: inline-block;
        }

        .customer-info div:not(:last-child) span {
            margin-left: 10px;
        }

        .wp-post-image {
            max-width: 130px;
            height: auto;
            margin: 5px;
        }

        .total-table {
            width: 60%;
            float: left;
            margin-top: 5px;
        }

        .total-table tbody tr:last-child td {
            background: ##tpl-color##;
        }

        .customer-note, .footer-desc {
            text-align: justify;
            margin-top: 2rem;
            padding-bottom: 0;
            padding-right: 10px;
            border-right: 5px solid ##border-color##;
        }

        .signature {
            text-align: left;
        }

        .signature p {
            margin-bottom: 10px;
        }

        .wip-print {
            text-align: center;
            padding: 20px 0;
        }

        .wip-print button {
            background: #e67e22;
            border: none;
            padding: 5px 15px;
            border-radius: 3px;
            color: #ffffff;
            cursor: pointer;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        @media print {
            .wip-print {
                display: none;
            }
        }

        .wip-invoice.condensed {
            line-height: 20px;
        }

        .wip-invoice.condensed {
            line-height: 20px;
        }

        .wip-invoice.condensed p {
            margin: 0;
            line-height: 20px;
        }

        .wip-invoice.condensed td,
        .wip-invoice.condensed th {
            padding: 0 4px;
        }

        .wip-invoice.condensed .customer-info {
            padding: 4px;
        }

        .wip-invoice.condensed .customer-note,
        .wip-invoice.condensed .footer-desc {
            margin-top: 20px;
        }

        img.watermark {
            opacity: ##watermark-opacity##;
            position: absolute;
            top: 50%;
            right: 50%;
            transform: translateX(50%) translateY(-50%);
        }
    </style>
</head>
<body>
    <div class="wip-invoice ##condensed##">
        ##watermark##
        <table class="shop-table">
            <tbody>
            <tr>
                <td>
                    <p>
                        <bdi>##store-email##</bdi>
                    </p>
                    <p>
                        <bdi>##store-phone##</bdi>
                    </p>
                </td>
                <td>
                    ##store-logo##
                    <p>##store-title##</p>
                    <p><bdi>##store-url##</bdi></p>
                </td>
                <td>
                    <p>
                        <span>تاریخ چاپ: </span>
                        <bdi>##invoice-date##</bdi>
                    </p>
                    <p>
                        <span>شماره سفارش: </span>
                        <bdi>##invoice-number##</bdi>
                    </p>
                    <div class="barcode">##barcode##</div>
                </td>
            </tr>
            </tbody>
            <tfoot class="sender">
            <tr>
                <td colspan="3">
                    <p>##store-address## ##store-postcode##</p>
                </td>
            </tr>
            </tfoot>
        </table>
        <div class="customer-info">
            <strong>گیرنده: </strong>
            <div>##customer-address##</div>
            <div class="national-id">##customer-national-id##</div>
            <div>##customer-phone##</div>
            <div>##customer-email##</div>
            <div>##order-date##</div>
            <div>##shipping-method##</div>
            <div>##transaction-id##</div>
        </div>
        ##order-table##
        ##total-table##
        <div style="display: block; clear: both;"></div>
        ##customer-note##
        <p class="footer-desc">##footer-desc##</p>
        <div class="signature">
            <p>مهر و امضا</p>
            ##signature##
        </div>
    </div>
    <p class="wip-print"><button onclick="window.print()">چاپ برگه</button></p>
</body>
</html>