<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
	<meta charset="UTF-8">
    <title>فاکتور</title>
	<style>
		/* Hide page header and footer when printing page */
		@page {
			size: auto;
			margin: 0;
		}

		/* Show background color when printing */
		@media print {
			body {
				-webkit-print-color-adjust: exact;
			}
		}

        /* Avoid extra blank page at end while printing */
        @media print {
            html, body {
                height: 99%;
                page-break-after: avoid;
                page-break-before: avoid;
            }
            .wip-invoice {
                page-break-after: auto;
            }
        }

		##font-face##

		body {
            margin: ##margin##px;
			padding: 0;
		}

        .d-none {
            display: none !important;
        }

        .clearfix:after {
            clear: both;
            content: '';
            display: block;
        }

		.wip-invoice {
			font-size: ##font-size##px;
			font-family: ##font-family##Tahoma, sans-serif;
			line-height: 34px;
			direction: rtl;
			color: #000000;
			margin: 0;
            position: relative;
		}

        .wip-is-email {
            border: 1px solid ##border-color##;
        }

		p {
			margin: 4px 0;
			font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
			line-height: 34px;
		}

		th, td {
			vertical-align: middle;
			padding: 7px 20px;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
		}

		bdi {
			direction: ltr;
		}

        ins {
            display: block;
            text-decoration: none;
        }

		table {
			width: 100%;
			border-collapse: collapse;
		}

		strong {
			font-weight: bold;
		}

		.shop-table {
			border-bottom: 2px solid ##border-color##;
		}

		.shop-table td {
			padding: 30px;
			text-align: center;
		}

		.barcode > div {
			margin: auto;
		}

		.invoice-title {
			background: ##tpl-color##;
			color: #ffffff;
			font-size: 23px;
			padding: 5px 30px;
			display: inline-block;
			position: relative;
			bottom: 22px;
			font-weight: bold;
		}

		.invoice-title:after {
			content: '';
			border-top: 22px solid transparent;
			border-bottom: 22px solid transparent;
			border-right: 22px solid ##border-color##;
			width: 0;
			height: 0;
			position: absolute;
			left: -22px;
			top: 0;
		}

        .post-info {
            margin: 15px 0;
            padding-right: 15px;
        }

		.post-info > div {
			width: 40%;
			padding: 0 40px 15px 20px;
			float: right;
            border-right: 5px solid ##border-color##;
		}

		.order-table th, .order-table td {
			text-align: center;
			border-bottom: 1px solid ##border-color##;
		}

		.order-table th {
			background: ##tpl-color## !important;
			color: #ffffff;
		}

        .wp-post-image {
            max-width: 130px;
            height: auto;
            margin: 5px;
        }

        .total-quantity, .discount-amount {
            padding-left: 20px;
        }

		.total-table {
			width: 60%;
		}

        .total-table td {
            text-align: center;
        }

		.total-table tr:last-child td {
			background: ##tpl-color##;
			color: #ffffff;
		}

		.total-table tr:last-child td:last-child {
			position: relative;
		}

		.total-table tr:last-child td:last-child:after {
			content: '';
			border-top: 24px solid transparent;
			border-bottom: 24px solid transparent;
			border-right: 24px solid ##border-color##;
			width: 0;
			height: 0;
			position: absolute;
			left: -24px;
			top: 0;
		}

		.customer-note, .footer-desc {
			text-align: justify;
			margin: 30px 50px;
            padding-bottom: 0;
            padding-right: 10px;
            border-right: 5px solid ##border-color##;
		}

        .signature {
            text-align: left;
            padding-left: 20px;
        }

        .signature p {
            margin-bottom: 10px;
        }

        .wip-print {
            text-align: center;
            padding: 20px 0;
        }

        .wip-print button {
            background: #e67e22;
            border: none;
            padding: 5px 15px;
            border-radius: 3px;
            color: #ffffff;
            cursor: pointer;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        @media print {
            .wip-print {
                display: none;
            }
        }

        .wip-invoice.condensed {
            line-height: 20px;
        }

        .wip-invoice.condensed p {
            margin: 0;
            line-height: 20px;
        }

        .wip-invoice.condensed th,
        .wip-invoice.condensed td {
            padding: 0 7px;
        }

        .wip-invoice.condensed .shop-table td {
            padding: 7px 7px 15px 7px;
        }

        .wip-invoice.condensed .invoice-title {
            font-size: 16px;
            bottom: 17px;
        }

        .wip-invoice.condensed .invoice-title:after {
            border-top-width: 15px;
            border-bottom-width: 15px;
            border-right-width: 15px;
            left: -15px;
        }

        .wip-invoice.condensed .post-info > div {
            padding: 5px 15px;
        }

        .wip-invoice.condensed .total-table tr:last-child td:last-child:after {
            border-top-width: 10px;
            border-bottom-width: 10px;
            border-right-width: 10px;
            left: -10px;
        }

        .wip-invoice.condensed .customer-note,
        .wip-invoice.condensed .footer-desc {
            margin: 20px;
        }

        img.watermark {
            opacity: ##watermark-opacity##;
            position: absolute;
            top: 50%;
            right: 50%;
            transform: translateX(50%) translateY(-50%);
        }
	</style>
</head>
<body>
    <div class="wip-invoice ##condensed##">
        ##watermark##
        <table class="shop-table">
            <tbody>
            <tr>
                <td>
                    ##store-logo##
                    <p>
                        <bdi>##store-url##</bdi>
                    </p>
                </td>
                <td>
                    <p>##store-title##</p>
                    <p><bdi>##store-phone##</bdi></p>
                    <p><bdi>##store-email##</bdi></p>
                </td>
                <td>
                    <p>
                        <span>تاریخ چاپ: </span>
                        <bdi>##invoice-date##</bdi>
                    </p>
                    <p>
                        <span>شماره سفارش: </span>
                        <bdi>##invoice-number##</bdi>
                    </p>
                    <div class="barcode">##barcode##</div>
                </td>
            </tr>
            </tbody>
        </table>
        <div class="invoice-title">صورتحساب</div>
        <div class="post-info clearfix">
            <div class="sender">
                <p>##store-address## ##store-postcode##</p>
            </div>
            <div>
                <p><strong>گیرنده:</strong> ##customer-address## <span class="national-id">##customer-national-id##</span> ##customer-phone## ##customer-email## ##order-date## ##shipping-method## ##transaction-id##</p>
            </div>
        </div>
        ##order-table##
        ##total-table##
        ##customer-note##
        <p class="footer-desc">##footer-desc##</p>
        <div class="signature">
            <p>مهر و امضا</p>
            ##signature##
        </div>
    </div>
    <p class="wip-print">
        <button onclick="window.print()">چاپ برگه</button>
    </p>
</body>
</html>