<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>فاکتور</title>
    <style>
        /* Hide page header and footer when printing page*/
        @page {
            size: auto;
            margin: 0;
        }

        /* Show background color when printing*/
        @media print {
            body {
                -webkit-print-color-adjust: exact;
            }
        }

        /* Avoid extra blank page at end while printing */
        @media print {
            html, body {
                height: 99%;
                page-break-after: avoid;
                page-break-before: avoid;
            }
            .wip-invoice {
                page-break-after: auto;
            }
        }

        ##font-face##

        body {
            margin: ##margin##px;
            padding: 0;
        }

        .wip-invoice {
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 34px;
            direction: rtl;
            color: #000000;
            margin: 0;
            position: relative;
        }

        .wip-is-email {
            border: 1px solid ##border-color##;
        }

        .d-none {
            display: none !important;
        }

        bdi {
            direction: ltr;
        }

        ins {
            display: block;
            text-decoration: none;
        }

        p {
            margin: 7px 0;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 34px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td, th {
            padding: 6px 15px;
            text-align: right;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        caption, strong {
            font-weight: bold;
        }

        .wrapper {
            padding: 0 30px;
        }

        .shop-table {
            table-layout: fixed;
            background: ##tpl-color##;
            color: #ffffff;
        }

        .shop-table td {
            padding: 15px;
        }

        .shop-table .invoice-title {
            font-size: 32px;
        }

        .shop-table2 {
            margin: 15px 0 0 30px;

        }

        .footer-table2 tr td:nth-child(2) {
            text-align: center;
        }

        .footer-table2 tr td:nth-child(3) {
            text-align: left;
        }

        .customer-info {
            table-layout: fixed;
            margin: 20px 0;
        }

        .m-0 {
            margin: 0;
        }

        .barcode > div {
            margin: auto;
        }

        .customer-info td {
            border-right: 5px solid ##tpl-color##;
        }

        .table-bordered td, .table-bordered th {
            border-bottom: 1px solid ##border-color##;
        }

        .table-bordered th {
            border-bottom-width: 3px;
        }

        .wp-post-image {
            max-width: 130px;
            height: auto;
            margin: 5px;
        }

        .total-table {
            width: 60%;
            float: left;
            margin-top: 5px;
            margin-bottom: 2rem;
        }

        .total-table.table-bordered td {
            border-bottom: none;
        }

        .total-table td {
            text-align: left;
        }

        .customer-note, .footer-desc {
            text-align: justify;
            margin-bottom: 2rem;
            padding-bottom: 0;
            padding-right: 10px;
            border-right: 5px solid ##border-color##;
        }

        .signature {
            text-align: left;
        }

        .signature p {
            margin-bottom: 10px;
        }

        .wip-print {
            text-align: center;
            padding: 20px 0;
        }

        .wip-print button {
            background: #e67e22;
            border: none;
            padding: 5px 15px;
            border-radius: 3px;
            color: #ffffff;
            cursor: pointer;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        @media print {
            .wip-print {
                display: none;
            }
        }

        .wip-invoice.condensed {
            line-height: 20px;
        }

        .wip-invoice.condensed {
            line-height: 20px;
        }

        .wip-invoice.condensed p {
            line-height: 20px;
        }

        .wip-invoice.condensed .wrapper .customer-info {
            margin: 10px;
        }

        .wip-invoice.condensed .total-table {
            margin-bottom: 1rem;
        }

        .wip-invoice.condensed .customer-note,
        .wip-invoice.condensed .footer-desc {
            margin-top: 0.5rem;
            margin-bottom: 0.5rem;
        }

        img.watermark {
            opacity: ##watermark-opacity##;
            position: absolute;
            top: 50%;
            right: 50%;
            transform: translateX(50%) translateY(-50%);
        }
    </style>
</head>
<body>
    <div class="wip-invoice ##condensed##">
        ##watermark##
        <table class="shop-table">
            <tr>
                <td class="invoice-title"><strong>صورتحساب</strong></td>
                <td valign="top">
                    <p>##store-title##</p>
                    <p>
                        <bdi>##store-email##</bdi>
                    </p>
                    <p>
                        <bdi>##store-url##</bdi>
                    </p>
                </td>
                <td valign="top" class="sender">
                    <p>##store-address## ##store-postcode##</p>
                </td>
            </tr>
        </table>
        <table class="shop-table2">
            <tr>
                <td valign="middle">##store-logo##</td>
                <td valign="middle"><div class="barcode">##barcode##</div></td>
                <td valign="middle">
                    <bdi>##store-phone##</bdi>
                </td>
            </tr>
        </table>
        <div class="wrapper">
            <table class="customer-info">
                <tr>
                    <td valign="top">
                        <strong>گیرنده:</strong>
                        <p>##customer-address## <span class="national-id">##customer-national-id##</span> ##customer-phone## ##customer-email## ##order-date## ##shipping-method## ##transaction-id##</p>
                    </td>
                    <td valign="top">
                        <p class="m-0">شماره سفارش:</p>
                        <p class="m-0">
                            <bdi>##invoice-number##</bdi>
                        </p>
                        <p class="m-0">تاریخ ارسال:</p>
                        <p class="m-0">
                            <bdi>##invoice-date##</bdi>
                        </p>
                    </td>
                </tr>
            </table>
            ##order-table##
            ##total-table##
            <div style="display: block; clear: both;"></div>
            ##customer-note##
            <p class="footer-desc">##footer-desc##</p>
            <div class="signature">
                <p>مهر و امضا</p>
                ##signature##
            </div>
        </div>
    </div>
    <p class="wip-print">
        <button onclick="window.print()">چاپ برگه</button>
    </p>
</body>
</html>