<style>
    h2 div {
        display: none;
    }

    .wip-orders-table th {
        font-weight: bold;
        color: #273c75 !important;
    }

    .column-products {
        width: 220px;
    }

    #wip_date_start,
    #wip_date_end {
        padding: 2px 5px !important;
        width: 100px !important;
    }

    .total-stats {
        float: left;
        background-color: #dcdde1;
        border: 1px solid #c8c9cd;
    }

    .wrap:after {
        clear: both;
        display: block;
        content: '';
    }

    .total-stats > span {
        display: inline-block;
        padding: 7px;
    }
</style>
<div class="wrap">
    <h2>
        <span>سفارش‌ها</span>
        <div>
            <span class="date">تاریخ چاپ: <bdi dir="ltr"><?php echo date_i18n( 'Y/m/d H:i', time() ); ?></bdi> | </span>
			<?php
			if ( isset( $_GET['state_filter'] ) && ! empty( $_GET['state_filter'] ) ) {
				echo wip_get_state_name( 'IR', $_GET['state_filter'] );
			}
			if ( isset( $_GET['status_filter'] ) && ! empty( $_GET['status_filter'] ) ) {
				echo ' | ' . wc_get_order_statuses()[ $_GET['status_filter'] ];
			}
			if ( isset( $_GET['date_end'] ) && ! empty( $_GET['date_end'] ) ) {
				echo ' | <bdi dir="ltr">' . str_replace( '-', '/', $_GET['date_end'] ) . '</bdi>';
			}
			if ( isset( $_GET['date_start'] ) && ! empty( $_GET['date_start'] ) ) {
				echo ' - <bdi dir="ltr">' . str_replace( '-', '/', $_GET['date_start'] ) . '</bdi>';
			}
			?>
        </div>
    </h2>
    <form method="get" action="<?php echo esc_url( admin_url( 'admin.php' ) ); ?>">
        <input type="hidden" name="page" value="wip-orders">
        <div class="tablenav top">
            <div class="alignleft actions">
				<?php echo wip_html_states(); ?>
				<?php echo wip_html_order_statuses(); ?>
                <input type="text" id="wip_date_start" name="date_start" autocomplete="off"
                       value="<?php echo isset( $_GET['date_start'] ) ? $_GET['date_start'] : ''; ?>" placeholder="تاریخ شروع">
                <input type="text" id="wip_date_end" name="date_end" autocomplete="off"
                       value="<?php echo isset( $_GET['date_end'] ) ? $_GET['date_end'] : ''; ?>" placeholder="تاریخ پایان">
                <input type="submit" class="button" value="صافی">
            </div>
            <a href="<?php echo esc_url( wip_get_orders_print_url() ); ?>"
               class="button button-primary" target="_blank" style="float: left; margin-left: 0;">چاپ سفارش‌ها</a>
        </div>
    </form>
    <table class="wip-orders-table wp-list-table widefat fixed striped posts">
        <thead>
        <tr>
            <th scope="col" class="manage-column" style="width: 60px;">ردیف</th>
            <th scope="col" class="manage-column">نام مشتری</th>
            <th scope="col" class="manage-column">استان/شهر</th>
            <th scope="col" class="manage-column">تاریخ سفارش</th>
            <th scope="col" class="manage-column column-products">محصولات</th>
            <th scope="col" class="manage-column">قیمت فروش</th>
            <th scope="col" class="manage-column">قیمت تامین کننده</th>
        </tr>
        </thead>
        <tbody>
		<?php
		$orders = wip_get_orders();

		$total_count          = 0;
		$total_price          = 0;
		$total_provider_price = 0;

		if ( count( $orders ) ) {
			$i = 0;
			foreach ( $orders as $order_id ) {
				$order = wc_get_order( $order_id );

				// TODO billing or shipping
				$state_name = wip_get_state_name( $order->get_billing_country(), $order->get_billing_state() );
				?>
                <tr>
                    <td style="width: 60px;"><?php echo $i + 1; ?></td>
                    <td>
                        <p><?php echo $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(); ?></p>
                        <p style="color: #989898;"><?php echo $order->get_billing_phone(); ?></p>
                    </td>
                    <td><?php echo $state_name . '/' . $order->get_billing_city(); ?></td>
                    <td>
                        <bdi dir="ltr"><?php echo date_i18n( 'Y/m/d - H:i', strtotime( $order->order_date ) ); ?></bdi>
                        <p><?php echo $order->get_payment_method_title(); ?></p>
                    </td>
                    <td class="column-products">
						<?php
						$j = 0;
						foreach ( $order->get_items() as $item_id => $item_data ) {
							$product = $item_data->get_product();
							if ( $product ) {
								$product_quantity = $item_data->get_quantity();
								$product_sku      = $product->get_sku();
								$product_name     = $product->get_name();

								echo '<p>' . ( $j + 1 ) . '- ' . $product_name;
								echo '<span style="color: #989898;"> | تعداد:' . $product_quantity . '</span>';
								echo $product_sku ? ' | <span style="color: #989898;">کد کالا:' . $product_sku . '</span></p>' : '';
							}
							$j ++;
						}
						?>
                    </td>
                    <td>
						<?php
						foreach ( $order->get_items() as $item_id => $item_data ) {
							$product = $item_data->get_product();

							$product_price = $item_data->get_total() / $item_data->get_quantity();

							echo '<p>' . wc_price( $product_price ) . '</p>';

							$total_count += $item_data->get_quantity();
							$total_price += $product_price;
						}
						?>
                        <hr>
                        <p><strong>جمع: <?php echo wc_price( $order->get_total() ); ?></strong></p>
                    </td>
                    <td>
						<?php
						foreach ( $order->get_items() as $item_id => $item_data ) {
							$product = $item_data->get_product();

							if ( $product ) {
								$product_id = $product->get_id();

								$key = '_wsm_provider_price';
								if ( $product->is_type( 'variation' ) ) {
									$key = '_provider_price';
								}

								$provider_price = get_post_meta( $product_id, $key, true );

								$total_provider_price += intval( $provider_price );

								$provider_price = $provider_price ? wc_price( esc_html( $provider_price ) ) : '__';

								echo '<p>' . $provider_price . '</p>';
							}
						}
						?>
                    </td>
                </tr>
				<?php
				$i ++;
			}
		} else {
			echo '<tr><td colspan="7">سفارشی یافت نشد!</td></tr>';
		}
		?>
        </tbody>
        <tfoot>
        <tr>
            <th scope="col" class="manage-column">ردیف</th>
            <th scope="col" class="manage-column">نام مشتری</th>
            <th scope="col" class="manage-column">استان/شهر</th>
            <th scope="col" class="manage-column">تاریخ سفارش</th>
            <th scope="col" class="manage-column column-products">محصولات</th>
            <th scope="col" class="manage-column">قیمت فروش</th>
            <th scope="col" class="manage-column" style="width: 60px;">قیمت تامین کننده</th>
        </tr>
        </tfoot>
    </table>
    <p class="total-stats">
        <span>تعداد: <?php echo number_format( $total_count ); ?></span>&nbsp;&nbsp;|&nbsp;&nbsp;
        <span>قیمت فروش: <?php echo wc_price( $total_price ); ?></span>&nbsp;&nbsp;|&nbsp;&nbsp;
        <span>قیمت تامین کننده: <?php echo wc_price( $total_provider_price ); ?></span>
    </p>
</div>