<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>برچسب پستی</title>
    <style>
        /* Hide page header and footer when printing page */
        @page {
            size: auto;
            margin: 0;
        }

        /* Show background color when printing */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
            }
        }

        /* Avoid extra blank page at end while printing */
        @media print {
            html, body {
                height: 99%;
                page-break-after: avoid;
                page-break-before: avoid;
            }
        }

        ##font-face##

        html, body {
            height: 100%;
        }

        body {
            margin: ##margin##px;
            padding: 0;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 28px;
            direction: rtl;
            color: #000000;
        }

        bdi {
            direction: ltr;
        }

        p {
            margin: 7px 0;
            font-size: ##font-size##px;
            line-height: 28px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        td {
            vertical-align: middle;
            padding: 7px 15px;
            text-align: right;
            border: 1px solid #666666;
        }

        caption, strong {
            font-weight: bold;
        }

        .wip-post-label {
            background-image: repeating-linear-gradient(135deg, #cf2004 0px, #cf2004 15px, transparent 15px, transparent 25px, #3ea8f2 25px, #3ea8f2 40px, transparent 40px, transparent 50px);
            padding: 10px;
        }

        .wip-post-label-inner {
            background: #ffffff;
            height: 100%;
            padding: 15px;
        }

        table tfoot div > div {
            display: inline-block;
        }

        table tfoot div > div:not(:last-child):after {
            content: '|';
            margin: 0 5px;
        }

        .barcode {
            margin-top: 10px;
        }

        .woocommerce-Price-amount {
            display: none !important;
        }

        .shipped_via {
            font-size: ##font-size##px !important;
        }

        .print {
            text-align: center;
            padding: 20px 0;
        }

        .print button {
            background: #e67e22;
            border: none;
            padding: 5px 15px;
            border-radius: 3px;
            color: #ffffff;
            cursor: pointer;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        @media print {
            .print {
                display: none;
            }
        }
    </style>
</head>
<body>
<div class="wip-post-label">
    <div class="wip-post-label-inner">
        <table>
            <tbody>
            <tr>
                <td style="text-align: center;">##store-logo##</td>
                <td rowspan="2">
                    <strong>فرستنده:</strong>
                    <p>##store-title##</p>
                    <p>##store-address## ##store-postcode##</p>
                    <p>##store-phone##</p>
                    <p style="float: left">
                        <bdi>##store-url##</bdi>
                    </p>
                    <br>
                    <div class="barcode" style="float: left">##barcode##</div>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>گیرنده:</strong>
                    <div>
                        <div>##customer-address##</div>
                        <div>##customer-phone##</div>
                        <div>##order-date##</div>
                    </div>
                </td>
            </tr>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="2">
                    <div>
                        <div>##shipping-method##</div>
                        <div>##payment-method##</div>
                        <div><strong>شماره سفارش:</strong> <bdi>##invoice-number##</bdi></div>
                        <div><strong>تاریخ ارسال:</strong> <bdi>##invoice-date##</bdi></div>
                    </div>
                </td>
            </tr>
            </tfoot>
        </table>
    </div>
</div>
<p class="print">
    <button onclick="window.print()">چاپ برگه</button>
</p>
</body>
</html>