<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>برچسب پستی</title>
    <style>
        /* Hide page header and footer when printing page */
        @page {
            size: auto;
            margin: 0;
        }

        /* Show background color when printing */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
            }
        }

        /* Avoid extra blank page at end while printing */
        @media print {
            html, body {
                height: 99%;
                page-break-after: avoid;
                page-break-before: avoid;
            }
        }

        ##font-face##

        html, body {
            height: 100%;
        }

        body {
            margin: ##margin##px;
            padding: 0;
            font-size: ##font-size##px;
            font-family: ##font-family##Tahoma, sans-serif;
            line-height: 28px;
            direction: rtl;
            color: #000000;
        }

        bdi {
            direction: ltr;
        }

        p {
            margin: 7px 0;
            font-size: ##font-size##px;
            line-height: 28px;
        }

        strong {
            font-weight: bold;
        }

        .wip-post-label {
            padding: 10px;
        }

        .wip-post-label-inner {
            background: #ffffff;
            height: 100%;
            padding: 15px;
            border: 1px dashed #000;
        }

        bdi {
            direction: ltr;
        }

        .barcode > div {
            margin: auto;
        }

        .print {
            text-align: center;
            padding: 20px 0;
        }

        .print button {
            background: #e67e22;
            border: none;
            padding: 5px 15px;
            border-radius: 3px;
            color: #ffffff;
            cursor: pointer;
            font-family: ##font-family##Tahoma, sans-serif;
        }

        @media print {
            .print {
                display: none;
            }
        }
    </style>
</head>
<body>
<div class="wip-post-label">
    <div class="wip-post-label-inner">
        <strong>فرستنده:</strong> ##store-title##
        <p>##store-address## ##store-postcode## ##store-phone##</p>
        <div class="barcode">##barcode##</div>
    </div>
</div>
<p class="print">
    <button onclick="window.print()">چاپ برگه</button>
</p>
</body>
</html>