<?php
/**
 * Plugin Name: صدور فاکتور ووکامرس
 * Plugin URI: https://zhaket.com/product/woocommerce-invoice-pro/
 * Description: توسط این افزونه شما قادر خواهید بود یک فاکتور کاملا پیشرفته برای سفارشات ووکامرس خود ایجاد و چاپ کنید. همچنین قابلیت ارسال خودکار فاکتور برای مشتری را نیز دارا میباشد.
 * Version: 9.4.0
 * Author: سید رضا صالحی
 * Author URI: http://sreza-salehi.ir/
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Plugin base class
 */
final class WIP_Woocommerce_Invoice_Pro {

	private static $instance = null;

	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	private function __construct() {
		//date_default_timezone_set( 'Asia/Tehran' );

		$this->define_constants();

		register_activation_hook( __FILE__, array( $this, 'plugin_activation' ) );
		register_deactivation_hook( __FILE__, 'plugin_deactivation' );

		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'add_action_links' ) );

		$this->_include();

		if ( function_exists( '__autoload' ) ) {
			spl_autoload_register( '__autoload' );
		}
		spl_autoload_register( array( $this, 'autoload' ) );

		$this->load_assets();

		WIP_Shop_Order_MTB::init();
		WIP_Send_Email::auto_send();

		$ajax_handler = new WIP_Ajax();
		$ajax_handler->register_callback();

		new WIP_Orders_Menu();
		if ( ! class_exists( 'WSM_Woo_Warehouse_Manager' ) ) {
			new WIP_Product_Field();
		}
	}

	private function define_constants() {
		define( 'WIP_VERSION', '9.4.0' );

		define( 'WIP_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'WIP_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );

		define( 'WIP_INC_PATH', trailingslashit( WIP_PATH . 'includes' ) );
		define( 'WIP_CLASS_PATH', trailingslashit( WIP_PATH . 'classes' ) );
		define( 'WIP_TPL_PATH', trailingslashit( WIP_PATH . 'templates' ) );

		define( 'WIP_FONTS_URL', trailingslashit( WIP_URL . 'assets/fonts' ) );
		define( 'WIP_JS_URL', trailingslashit( WIP_URL . 'assets/js' ) );
		define( 'WIP_CSS_URL', trailingslashit( WIP_URL . 'assets/css' ) );
	}

	public function plugin_activation() {
		if ( get_option( 'wip_version' ) != WIP_VERSION ) {
			update_option( 'wip_version', WIP_VERSION );
		}

		$this->insert_default_options();
	}

	public function plugin_deactivation() {

	}

	/**
	 * Auto include all class files in classes path entire project
	 *
	 * @param $class
	 */
	public function autoload( $class ) {
		if ( false !== strpos( $class, 'WIP_' ) ) {
			$class_file = WIP_CLASS_PATH . 'class-' . str_replace( '_', '-', substr( strtolower( $class ), 4 ) ) . '.php';
			if ( is_file( $class_file ) && file_exists( $class_file ) ) {
				include_once $class_file;
			}
		}
	}

	private function _include() {
		include( WIP_INC_PATH . 'functions.php' );
		include( WIP_INC_PATH . 'settings-tab.php' );
		include( WIP_INC_PATH . 'order-extra-column.php' );
		include( WIP_INC_PATH . 'order-action.php' );
		include( WIP_INC_PATH . 'my-order-action.php' );
		include( WIP_INC_PATH . 'inventory-field.php' );
		include( WIP_INC_PATH . 'checkout-field.php' );
	}

	/**
	 * Applied to the list of links to display on the plugins page (beside the activate/deactivate links)
	 *
	 * @param $links
	 *
	 * @return array
	 */
	public function add_action_links( $links ) {
		$links[] = '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=woo_invoice_pro' ) . '">تنظیمات</a>';

		return $links;
	}

	/**
	 * Insert default options for plugin in database
	 */
	private function insert_default_options() {
		if ( ! get_option( 'wc_wip_settings_store_title' ) ) {
			update_option( 'wc_wip_settings_store_title', get_bloginfo( 'name' ) );
		}
		if ( ! get_option( 'wc_wip_settings_store_url' ) ) {
			update_option( 'wc_wip_settings_store_url', home_url() );
		}
		if ( ! get_option( 'wc_wip_settings_store_postcode' ) ) {
			update_option( 'wc_wip_settings_store_postcode', get_option( 'woocommerce_store_postcode' ) );
		}
		if ( ! get_option( 'wc_wip_settings_store_email' ) ) {
			update_option( 'wc_wip_settings_store_email', get_option( 'admin_email' ) );
		}
		if ( ! get_option( 'wc_wip_settings_store_address' ) ) {
			$address = get_option( 'woocommerce_store_city' ) . ' - ' . get_option( 'woocommerce_store_address' ) . ' - ' . get_option( 'woocommerce_store_address_2' );
			update_option( 'wc_wip_settings_store_address', $address );
		}
		if ( ! get_option( 'wc_wip_settings_customer_name' ) ) {
			update_option( 'wc_wip_settings_customer_name', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_customer_phone' ) ) {
			update_option( 'wc_wip_settings_customer_phone', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_customer_postcode' ) ) {
			update_option( 'wc_wip_settings_customer_postcode', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_customer_address' ) ) {
			update_option( 'wc_wip_settings_customer_address', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_order_table' ) ) {
			update_option( 'wc_wip_settings_order_table', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_total_table' ) ) {
			update_option( 'wc_wip_settings_total_table', 'yes' );
		}
		if ( ! get_option( 'wc_wip_settings_font_family' ) ) {
			update_option( 'wc_wip_settings_font_family', 'iranyekan' );
		}
		if ( ! get_option( 'wc_wip_settings_tpl_color' ) ) {
			update_option( 'wc_wip_settings_tpl_color', '484848' );
		}
		if ( ! get_option( 'wc_wip_settings_font_size' ) ) {
			update_option( 'wc_wip_settings_font_size', 14 );
		}
		if ( ! get_option( 'wc_wip_settings_send_email' ) ) {
			update_option( 'wc_wip_settings_send_email', 'manual' );
		}
	}

	public function load_assets() {
		add_action( 'wp_enqueue_scripts', array( $this, 'load_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_admin_scripts' ) );
		$this->admin_head();
		$this->admin_footer();
	}

	public function load_scripts() {
		add_action( 'wp_head', function () {
			if ( in_array( 'dokan-lite/dokan.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
				echo '<style class="wip">';
				echo '.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type"]:before {
				  font-family: FontAwesome;
				  font-size: 12px;
				}
				.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type=invoice"]:before {
				  content: "\f0f6";
				}
				.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type=packing-slip"]:before {
				  content: "\f187";
				}
				.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type=post-label"]:before {
				  content: "\f003";
				}
				.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type=sender-post-label"]:before {
				  content: "\f290";
				}
				.dokan-dashboard .dokan-dashboard-content .dokan-order-action a[href*="wip-print-type=recipient-post-label"]:before {
				  content: "\f007";
				}';
				echo '</style>' . PHP_EOL;
			}
		}, 100 );
	}

	private function admin_head() {
		add_action( 'admin_head', function () {
			echo '<meta name="_wip_nonce" content="' . wp_create_nonce( 'ajax_nonce' ) . '">' . PHP_EOL;
			echo '<style>.postbox-container #woocommerce-invoice-pro .inside {text-align: center;}</style>';
		} );
	}

	private function admin_footer() {
		add_action( 'admin_footer', function () {
			if ( isset( $_GET['page'] ) && $_GET['page'] == 'wip-orders' ) {
				?>
                <script type="text/javascript">
                    jQuery(document).ready(function ($) {
                        $("#wip_date_start, #wip_date_end").persianDatepicker({
                            formatDate: "YYYY-MM-DD",
                        });
                    });
                </script>
				<?php
			}
		} );
	}

	public function load_admin_scripts() {
		wp_enqueue_media();
		if ( isset( $_GET['page'] ) && $_GET['page'] == 'wip-orders' ) {
			wp_register_style( 'persian-datepicker-css', WIP_CSS_URL . 'persianDatepicker-default.css', false, '0.1.0', false );
			wp_enqueue_style( 'persian-datepicker-css' );
			wp_register_script( 'persian-datepicker-js', WIP_JS_URL . 'persianDatepicker.min.js', array( 'jquery' ), '0.1.0', true );
			wp_enqueue_script( 'persian-datepicker-js' );
		}
		wp_register_script( 'wip-admin-scripts', WIP_JS_URL . 'admin-scripts.js', array( 'jquery' ), WIP_VERSION, true );
		wp_enqueue_script( 'wip-admin-scripts' );
		wp_localize_script( 'wip-admin-scripts', 'data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	public function __clone() {
	}

	public function __wakeup() {
	}
}

WIP_Woocommerce_Invoice_Pro::get_instance();
